/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.ReferencedTabletFile;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.tablet.MinCEnv;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinorCompactor
extends FileCompactor {
    private static final Logger log = LoggerFactory.getLogger(MinorCompactor.class);
    private final TabletServer tabletServer;
    private final MinorCompactionReason mincReason;

    public MinorCompactor(TabletServer tabletServer, Tablet tablet, InMemoryMap imm, ReferencedTabletFile outputFile, MinorCompactionReason mincReason, TableConfiguration tableConfig) {
        super(tabletServer.getContext(), tablet.getExtent(), Collections.emptyMap(), outputFile, true, (FileCompactor.CompactionEnv)new MinCEnv(mincReason, imm.compactionIterator()), Collections.emptyList(), (AccumuloConfiguration)tableConfig, tableConfig.getCryptoService(), tabletServer.getPausedCompactionMetrics());
        this.tabletServer = tabletServer;
        this.mincReason = mincReason;
    }

    private boolean isTableDeleting() {
        try {
            return this.tabletServer.getContext().getTableState(this.extent.tableId()) == TableState.DELETING;
        }
        catch (Exception e) {
            log.warn("Failed to determine if table " + this.extent.tableId() + " was deleting ", (Throwable)e);
            return false;
        }
    }

    protected Map<String, Set<ByteSequence>> getLocalityGroups(AccumuloConfiguration acuTableConf) throws IOException {
        return LocalityGroupUtil.getLocalityGroupsIgnoringErrors((AccumuloConfiguration)acuTableConf, (TableId)this.extent.tableId());
    }

    /*
     * Unable to fully structure code
     */
    public CompactionStats call() {
        outputFileName = this.getOutputFile();
        MinorCompactor.log.trace("Begin minor compaction {} {}", (Object)outputFileName, (Object)this.getExtent());
        sleepTime = 100;
        growthFactor = 4.0;
        maxSleepTime = 180000;
        reportedProblem = false;
        retryCounter = 0;
        MinorCompactor.runningCompactions.add(this);
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                ret = super.call();
                if (reportedProblem) {
                    ProblemReports.getInstance((ServerContext)this.tabletServer.getContext()).deleteProblemReport(this.getExtent().tableId(), ProblemType.FILE_WRITE, outputFileName);
                }
                var9_14 = ret;
                return var9_14;
            }
        }
        catch (IOException | UnsatisfiedLinkError e) {
            MinorCompactor.log.warn("MinC failed ({}) to create {} retrying ...", (Object)e.getMessage(), (Object)outputFileName);
            ProblemReports.getInstance((ServerContext)this.tabletServer.getContext()).report(new ProblemReport(this.getExtent().tableId(), ProblemType.FILE_WRITE, outputFileName, e));
            reportedProblem = true;
        }
        catch (NoClassDefFoundError | RuntimeException e) {
            ProblemReports.getInstance((ServerContext)this.tabletServer.getContext()).report(new ProblemReport(this.getExtent().tableId(), ProblemType.FILE_WRITE, outputFileName, e));
            if (retryCounter >= 4 && this.mincReason.equals((Object)MinorCompactionReason.RECOVERY)) {
                MinorCompactor.log.warn("MinC ({}) is stuck for too long during recovery, throwing error to reschedule.", (Object)this.getExtent(), (Object)e);
                throw new RuntimeException(e);
            }
            MinorCompactor.log.warn("MinC failed ({}) to create {} retrying ...", new Object[]{e.getMessage(), outputFileName, e});
            reportedProblem = true;
            ++retryCounter;
        }
        catch (FileCompactor.CompactionCanceledException e) {
            throw new IllegalStateException(e);
        }
        {
            sleep = sleepTime + ((SecureRandom)LazySingletons.RANDOM.get()).nextInt(sleepTime);
            MinorCompactor.log.debug("MinC failed sleeping {} ms before retrying", (Object)sleep);
            Uninterruptibles.sleepUninterruptibly((long)sleep, (TimeUnit)TimeUnit.MILLISECONDS);
            sleepTime = (int)Math.round(Math.min((double)maxSleepTime, (double)sleepTime * growthFactor));
            try {
                if (this.getVolumeManager().exists(new Path(outputFileName))) {
                    this.getVolumeManager().deleteRecursively(new Path(outputFileName));
                }
            }
            catch (IOException e) {
                MinorCompactor.log.warn("Failed to delete failed MinC file {} {}", (Object)outputFileName, (Object)e.getMessage());
            }
            if (!this.isTableDeleting()) ** GOTO lbl-1000
            var9_15 = new CompactionStats(0L, 0L, 0);
        }
        return var9_15;
lbl-1000:
        // 1 sources

        {
            ** continue;
        }
        finally {
            this.thread = null;
            MinorCompactor.runningCompactions.remove((Object)this);
        }
    }
}

