/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import jakarta.annotation.PreDestroy;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.http.HttpUpgradeHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;

public class PreDestroyAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    public PreDestroyAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    public void doHandle(Class clazz) {
        if (this.supportsPreDestroy(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.isAnnotationPresent(PreDestroy.class)) continue;
                if (m.getParameterCount() != 0) {
                    throw new IllegalStateException(String.valueOf(m) + " has parameters");
                }
                if (m.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(String.valueOf(m) + " is not void");
                }
                if (m.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(String.valueOf(m) + " throws checked exceptions");
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(String.valueOf(m) + " is static");
                }
                MetaData metaData = this._context.getMetaData();
                Origin origin = metaData.getOrigin("pre-destroy");
                if (origin != null && (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride)) {
                    return;
                }
                PreDestroyCallback callback = new PreDestroyCallback(clazz, m.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", (Object)lifecycles);
                }
                lifecycles.add((LifeCycleCallback)callback);
            }
        }
    }

    public boolean supportsPreDestroy(Class c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }
}

