/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="rest,security,configuration")
@XmlRootElement(name="oauth2")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OAuth2Definition
extends RestSecurityDefinition {
    @XmlAttribute
    private String authorizationUrl;
    @XmlAttribute
    private String tokenUrl;
    @XmlAttribute
    private String refreshUrl;
    @XmlAttribute
    @Metadata(enums="implicit,password,application,clientCredentials,accessCode,authorizationCode")
    private String flow;
    @XmlElement(name="scopes")
    private List<RestPropertyDefinition> scopes = new ArrayList<RestPropertyDefinition>();

    public OAuth2Definition() {
    }

    public OAuth2Definition(RestDefinition rest) {
        super(rest);
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public void setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public List<RestPropertyDefinition> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<RestPropertyDefinition> scopes) {
        this.scopes = scopes;
    }

    public OAuth2Definition flow(String flow) {
        this.setFlow(flow);
        return this;
    }

    public OAuth2Definition authorizationUrl(String authorizationUrl) {
        this.setAuthorizationUrl(authorizationUrl);
        return this;
    }

    public OAuth2Definition tokenUrl(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        return this;
    }

    public OAuth2Definition refreshUrl(String refreshUrl) {
        this.setRefreshUrl(refreshUrl);
        return this;
    }

    public OAuth2Definition password(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("password");
        return this;
    }

    public OAuth2Definition application(String tokenUrl) {
        return this.clientCredentials(tokenUrl);
    }

    public OAuth2Definition clientCredentials(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("clientCredentials");
        return this;
    }

    public OAuth2Definition accessCode(String authorizationUrl, String tokenUrl) {
        return this.authorizationCode(authorizationUrl, tokenUrl);
    }

    public OAuth2Definition authorizationCode(String authorizationUrl, String tokenUrl) {
        this.setAuthorizationUrl(authorizationUrl);
        this.setTokenUrl(tokenUrl);
        this.setFlow("authorizationCode");
        return this;
    }

    public OAuth2Definition withScope(String key, String description) {
        this.scopes.add(new RestPropertyDefinition(key, description));
        return this;
    }

    public RestSecuritiesDefinition end() {
        return this.rest.getSecurityDefinitions();
    }
}

