/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.startup;

import org.apache.camel.CamelContext;
import org.apache.camel.spi.StartupCondition;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class EnvStartupCondition
implements StartupCondition {
    private final String env;

    public EnvStartupCondition(String env) {
        ObjectHelper.notNullOrEmpty((String)env, (String)"ENV");
        this.env = env;
    }

    public String getName() {
        return "ENV";
    }

    public String getWaitMessage() {
        return "Waiting for OS Environment Variable: " + this.env;
    }

    public String getFailureMessage() {
        return "OS Environment Variable: " + this.env + " does not exist";
    }

    protected String lookupEnvironmentVariable(String env) {
        return IOHelper.lookupEnvironmentVariable((String)env);
    }

    public boolean canContinue(CamelContext camelContext) throws Exception {
        String value = this.lookupEnvironmentVariable(this.env);
        return ObjectHelper.isNotEmpty((String)value);
    }
}

