/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceProcessor
extends BaseProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceProcessor.class);
    private String id;
    private String routeId;
    private final FilterProcessor[] filters;
    private final int len;
    private final AsyncProcessor otherwise;
    private transient long notFiltered;

    public ChoiceProcessor(List<FilterProcessor> filters, Processor otherwise) {
        this.filters = filters.toArray(new FilterProcessor[0]);
        this.len = filters.size();
        this.otherwise = otherwise != null ? AsyncProcessorConverterHelper.convert((Processor)otherwise) : null;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        for (int i = 0; i < this.len; ++i) {
            FilterProcessor filter = this.filters[i];
            boolean matches = false;
            try {
                matches = filter.matches(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (!PipelineHelper.continueProcessing(exchange, "so breaking out of choice", LOG)) {
                callback.done(true);
                return true;
            }
            if (!matches) continue;
            return filter.getProcessor().process(exchange, callback);
        }
        if (this.otherwise != null) {
            ++this.notFiltered;
            return this.otherwise.process(exchange, callback);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "choice";
    }

    public List<FilterProcessor> getFilters() {
        return Arrays.asList(this.filters);
    }

    public Processor getOtherwise() {
        return this.otherwise;
    }

    public long getNotFilteredCount() {
        return this.notFiltered;
    }

    public void reset() {
        for (int i = 0; i < this.len; ++i) {
            this.filters[i].reset();
        }
        this.notFiltered = 0L;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.len > 0) {
            answer.addAll(Arrays.asList(this.filters));
        }
        if (this.otherwise != null) {
            answer.add((Processor)this.otherwise);
        }
        return answer;
    }

    public boolean hasNext() {
        return this.otherwise != null || this.len > 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object[])new Object[]{Arrays.asList(this.filters), this.otherwise});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{Arrays.asList(this.filters), this.otherwise});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.otherwise, Arrays.asList(this.filters)});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.otherwise, Arrays.asList(this.filters)});
    }
}

