/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.LinkedList;
import javax.management.AttributeNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.Converter;

public class CompositeDataAccessor
implements ObjectAccessor {
    @Override
    public Class<?> getType() {
        return CompositeData.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pCompositeData, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        CompositeData cd = (CompositeData)pCompositeData;
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            try {
                return pConverter.extractObject(cd.get(pathPart), pPathParts, pJsonify);
            }
            catch (InvalidKeyException exp) {
                return pConverter.getValueFaultHandler().handleException((Throwable)new AttributeNotFoundException("Invalid key for CompositeData '" + pathPart + "'"));
            }
        }
        return pJsonify ? this.compositeDataToJSON(pConverter, cd, pPathParts) : cd;
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pObject, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("CompositeData cannot be written to");
    }

    private Object compositeDataToJSON(ObjectToJsonConverter pConverter, CompositeData pData, Deque<String> pPath) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (String key : pData.getCompositeType().keySet()) {
            LinkedList<String> paths = new LinkedList<String>(pPath);
            try {
                ret.put((Object)key, pConverter.extractObject(pData.get(key), paths, true));
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (ret.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }
}

