/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import org.apache.activemq.artemis.api.core.DisconnectReason;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQRoutingContext;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.routing.RoutingHandler;

public class ActiveMQRoutingHandler
extends RoutingHandler<ActiveMQRoutingContext> {
    public ActiveMQRoutingHandler(ActiveMQServer server) {
        super(server);
    }

    public boolean route(CoreRemotingConnection connection, String username) throws Exception {
        if (!connection.isVersionSupportRouting()) {
            throw ActiveMQMessageBundle.BUNDLE.incompatibleClientServer();
        }
        return this.route(new ActiveMQRoutingContext(connection, username));
    }

    @Override
    public void refuse(ActiveMQRoutingContext context) throws Exception {
        switch (context.getResult().getStatus()) {
            case REFUSED_UNAVAILABLE: {
                throw ActiveMQMessageBundle.BUNDLE.connectionRouterNotReady(context.getRouter());
            }
            case REFUSED_USE_ANOTHER: {
                throw ActiveMQMessageBundle.BUNDLE.connectionRejected(context.getRouter());
            }
        }
    }

    @Override
    public void redirect(ActiveMQRoutingContext context) throws Exception {
        context.getConnection().disconnect(DisconnectReason.REDIRECT, context.getTarget().getNodeID(), context.getTarget().getConnector());
        throw ActiveMQMessageBundle.BUNDLE.connectionRedirected(context.getRouter(), context.getTarget().getConnector());
    }
}

