/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.activation;

import java.io.File;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;

final class ActivationSequenceUtils {
    private ActivationSequenceUtils() {
    }

    public static NodeManager applyCoordinationId(String nodeId, NodeManager nodeManager, File nodeManagerLockLocation) throws Exception {
        long activationSequence = nodeManager.getNodeActivationSequence();
        nodeManager.stop();
        FileLockNodeManager replicatedNodeManager = new FileLockNodeManager(nodeManagerLockLocation, true);
        replicatedNodeManager.start();
        replicatedNodeManager.setNodeID(nodeId);
        replicatedNodeManager.stopBackup();
        long freshActivationSequence = replicatedNodeManager.readNodeActivationSequence();
        assert (freshActivationSequence == activationSequence);
        return replicatedNodeManager;
    }
}

