/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.commands.messages.perf.BenchmarkService;
import org.apache.activemq.artemis.cli.commands.messages.perf.LiveStatistics;
import org.apache.activemq.artemis.cli.factory.ConnectionFactoryClosable;
import picocli.CommandLine;

public abstract class PerfCommand
extends ConnectionAbstract {
    @CommandLine.Option(names={"--show-latency"}, description={"Show latencies at interval on output. Default: disabled."})
    protected boolean showLatency = false;
    @CommandLine.Option(names={"--json"}, description={"Report file name. Default: none."})
    protected String reportFileName = null;
    @CommandLine.Option(names={"--hdr"}, description={"HDR Histogram Report file name. Default: none."})
    protected String hdrFileName = null;
    @CommandLine.Option(names={"--duration"}, description={"Test duration (in seconds). Default: 0."})
    protected int duration = 0;
    @CommandLine.Option(names={"--warmup"}, description={"Warmup time (in seconds). Default: 0."})
    protected int warmup = 0;
    @CommandLine.Option(names={"--message-count"}, description={"Total number of messages. Default: 0."})
    protected long messageCount = 0L;
    @CommandLine.Option(names={"--num-destinations"}, description={"If present, generate --num-destinations for each destination name, using it as a prefix and adding a number [0,--num-destinations) as suffix. Default: none."})
    protected int numDestinations = 1;
    @CommandLine.Option(names={"--tx-size"}, description={"Transaction size."}, hidden=true)
    protected long txSize;
    @CommandLine.Option(names={"--commit-interval"}, description={"Transaction size."})
    protected long commitInterval;
    @CommandLine.Parameters(description={"List of destination names. Each name can be prefixed with queue:// or topic:// and can be an FQQN in the form of <address>::<queue>. Default: queue://TEST."})
    protected List<String> destinations;
    private final CountDownLatch completed = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        if (this.txSize > 0L) {
            context.out.println("--tx-size is deprecated, please use --commit-interval");
            this.commitInterval = this.txSize;
        }
        try (ConnectionFactoryClosable factory = this.createConnectionFactory(this.brokerURL, this.user, this.password, null, this.protocol);){
            Destination[] jmsDestinations = PerfCommand.lookupDestinations(factory, this.destinations, this.numDestinations);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.onInterruptBenchmark();
                try {
                    this.completed.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }));
            try {
                this.onExecuteBenchmark(factory, jmsDestinations, context);
            }
            finally {
                this.completed.countDown();
            }
        }
        return null;
    }

    protected abstract void onExecuteBenchmark(ConnectionFactory var1, Destination[] var2, ActionContext var3) throws Exception;

    protected abstract void onInterruptBenchmark();

    protected boolean collectAndReportStatisticsWhileRunning(boolean warmingUp, LiveStatistics statistics, StringBuilder skratchBuffer, long endWarmup, long end, BenchmarkService benchmark) throws IOException {
        long tick;
        while (benchmark.isRunning() && (end == 0L || (tick = System.currentTimeMillis()) - end < 0L)) {
            if (endWarmup != 0L && warmingUp && (tick = System.currentTimeMillis()) - endWarmup >= 0L) {
                warmingUp = false;
            }
            statistics.sampleMetrics(warmingUp);
            skratchBuffer.setLength(0);
            statistics.outAtInterval(warmingUp, skratchBuffer, LiveStatistics.ReportInterval.sec, this.showLatency);
            if (!this.isSilentInput()) {
                this.getActionContext().out.println(skratchBuffer);
            }
            LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
        }
        return warmingUp;
    }

    protected final Destination[] lookupDestinations(ConnectionFactory factory) throws Exception {
        return PerfCommand.lookupDestinations(factory, this.destinations, this.numDestinations);
    }

    private static Destination[] lookupDestinations(ConnectionFactory factory, List<String> destinations, int numDestinations) throws Exception {
        List<String> destinationNames = destinations == null || destinations.isEmpty() ? Collections.singletonList("queue://TEST") : destinations;
        Destination[] jmsDestinations = new Destination[destinationNames.size() * numDestinations];
        try (Connection connection = factory.createConnection();
             Session session = connection.createSession();){
            int i = 0;
            for (String destinationName : destinationNames) {
                if (numDestinations == 1) {
                    jmsDestinations[i] = DestAbstract.getDestination(session, destinationName);
                    ++i;
                    continue;
                }
                for (int suffix = 0; suffix < numDestinations; ++suffix) {
                    jmsDestinations[i] = DestAbstract.getDestination(session, destinationName + suffix);
                    ++i;
                }
            }
        }
        return jmsDestinations;
    }

    public boolean isShowLatency() {
        return this.showLatency;
    }

    public PerfCommand setShowLatency(boolean showLatency) {
        this.showLatency = showLatency;
        return this;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public PerfCommand setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
        return this;
    }

    public String getHdrFileName() {
        return this.hdrFileName;
    }

    public PerfCommand setHdrFileName(String hdrFileName) {
        this.hdrFileName = hdrFileName;
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    public PerfCommand setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public PerfCommand setWarmup(int warmup) {
        this.warmup = warmup;
        return this;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public PerfCommand setMessageCount(long messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public int getNumDestinations() {
        return this.numDestinations;
    }

    public PerfCommand setNumDestinations(int numDestinations) {
        this.numDestinations = numDestinations;
        return this;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public PerfCommand setDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    public CountDownLatch getCompleted() {
        return this.completed;
    }
}

