/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromQueueReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPBridgeFromQueuePolicyManager
extends AMQPBridgeFromPolicyManager
implements ActiveMQServerConsumerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPBridgeQueuePolicy policy;
    private final Map<AMQPBridgeReceiverInfo, AMQPBridgeQueueReceiverManager> demandTracking = new HashMap<AMQPBridgeReceiverInfo, AMQPBridgeQueueReceiverManager>();
    private final String RECEIVER_INFO_ATTACHMENT_KEY = UUID.randomUUID().toString();

    public AMQPBridgeFromQueuePolicyManager(AMQPBridgeManager bridge, AMQPBridgeMetrics metric, AMQPBridgeQueuePolicy policy) {
        super(bridge, metric, policy.getPolicyName(), AMQPBridgeType.BRIDGE_FROM_QUEUE);
        Objects.requireNonNull(policy, "The Queue match policy cannot be null");
        this.policy = policy;
    }

    @Override
    public AMQPBridgeQueuePolicy getPolicy() {
        return this.policy;
    }

    @Override
    protected void scanManagedResources() {
        this.server.getPostOffice().getAllBindings().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(b -> {
            if (this.configuration.isReceiverDemandTrackingDisabled()) {
                this.reactIfQueueMatchesPolicy(b.getQueue());
            } else {
                this.checkQueueWithConsumerForMatch(b.getQueue());
            }
        });
    }

    @Override
    protected void safeCleanupManagerResources(boolean force) {
        try {
            this.demandTracking.values().forEach(manager -> {
                if (manager != null) {
                    if (this.isConnected() && !force) {
                        manager.shutdown();
                    } else {
                        manager.shutdownNow();
                    }
                }
            });
        }
        finally {
            this.demandTracking.clear();
        }
    }

    public synchronized void afterCreateConsumer(ServerConsumer consumer) {
        if (this.isActive() && !this.configuration.isReceiverDemandTrackingDisabled()) {
            this.reactIfQueueWithConsumerMatchesPolicy(consumer);
        }
    }

    public synchronized void afterCloseConsumer(ServerConsumer consumer, boolean failed) {
        AMQPBridgeReceiverInfo receiverInfo;
        if (this.isActive() && !this.configuration.isReceiverDemandTrackingDisabled() && (receiverInfo = (AMQPBridgeReceiverInfo)consumer.getAttachment(this.RECEIVER_INFO_ATTACHMENT_KEY)) != null && this.demandTracking.containsKey(receiverInfo)) {
            AMQPBridgeQueueReceiverManager manager = this.demandTracking.get(receiverInfo);
            logger.trace("Reducing demand on bridged queue {}", (Object)manager.getQueueName());
            manager.removeDemand(consumer);
        }
    }

    public synchronized void afterAddBinding(Binding binding) throws ActiveMQException {
        if (this.isActive() && this.configuration.isReceiverDemandTrackingDisabled() && binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            this.reactIfQueueMatchesPolicy(queueBinding.getQueue());
        }
    }

    public synchronized void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        if (this.isActive() && binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            String queueName = queueBinding.getQueue().getName().toString();
            this.demandTracking.values().removeIf(manager -> {
                if (manager.getQueueName().equals(queueName)) {
                    logger.trace("Bridged queue {} was removed, closing bridge receiver", (Object)queueName);
                    manager.shutdownNow();
                    return true;
                }
                return false;
            });
        }
    }

    private void checkQueueWithConsumerForMatch(Queue queue) {
        queue.getConsumers().stream().filter(consumer -> consumer instanceof ServerConsumer).map(c -> (ServerConsumer)c).forEach(this::reactIfQueueWithConsumerMatchesPolicy);
    }

    private void reactIfQueueWithConsumerMatchesPolicy(ServerConsumer consumer) {
        this.reactIfDemandMatchesPolicy(consumer.getQueue(), consumer, false);
    }

    private void reactIfQueueMatchesPolicy(Queue queue) {
        this.reactIfDemandMatchesPolicy(queue, null, true);
    }

    private void reactIfDemandMatchesPolicy(Queue queue, ServerConsumer consumer, boolean forceDemand) {
        String queueName = queue.getName().toString();
        String addressName = queue.getAddress().toString();
        if (this.testIfQueueMatchesPolicy(addressName, queueName)) {
            AMQPBridgeQueueReceiverManager manager;
            if (consumer != null) {
                logger.trace("AMQP Bridge from Queue Policy matched on consumer for Queue: {}", (Object)consumer.getQueue());
            } else {
                logger.trace("AMQP Bridge Queue Policy matched on Queue: {} when demand tracking disabled", (Object)queue.getName());
            }
            AMQPBridgeReceiverInfo receiverInfo = this.createReceiverInfo(consumer, queue);
            if (this.demandTracking.containsKey(receiverInfo)) {
                logger.trace("AMQP Bridge from Queue Policy manager found existing demand for queue: {}, adding demand", (Object)queueName);
                manager = this.demandTracking.get(receiverInfo);
            } else {
                manager = new AMQPBridgeQueueReceiverManager(this, this.RECEIVER_INFO_ATTACHMENT_KEY, this.configuration, receiverInfo, queue);
                this.demandTracking.put(receiverInfo, manager);
            }
            if (forceDemand) {
                manager.forceDemand();
            } else {
                manager.addDemand(consumer);
            }
        }
    }

    private boolean testIfQueueMatchesPolicy(String address, String queueName) {
        return this.policy.test(address, queueName);
    }

    private AMQPBridgeReceiver createBridgeReceiver(AMQPBridgeReceiverInfo receiverInfo) {
        Objects.requireNonNull(receiverInfo, "AMQP Bridge Queue receiver information object was null");
        if (logger.isTraceEnabled()) {
            logger.trace("AMQP Bridge {} creating queue receiver: {} for policy: {}", new Object[]{this.bridge.getName(), receiverInfo, this.policy.getPolicyName()});
        }
        return new AMQPBridgeFromQueueReceiver((AMQPBridgeFromPolicyManager)this, this.configuration, this.session, receiverInfo, this.policy, this.metrics.newReceiverMetrics());
    }

    private AMQPBridgeReceiverInfo createReceiverInfo(ServerConsumer consumer, Queue queue) {
        StringBuilder remoteAddressBuilder = new StringBuilder();
        if (this.policy.getRemoteAddressPrefix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressPrefix());
        }
        if (this.policy.getRemoteAddress() != null && !this.policy.getRemoteAddress().isBlank()) {
            remoteAddressBuilder.append(this.policy.getRemoteAddress());
        } else {
            remoteAddressBuilder.append(queue.getName().toString());
        }
        if (this.policy.getRemoteAddressSuffix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressSuffix());
        }
        String filterString = AMQPBridgeFromQueuePolicyManager.selectFilter(this.policy.getFilter(), this.configuration.isIgnoreQueueFilters() ? null : queue.getFilter(), this.configuration.isIgnoreSubscriptionFilters() || consumer == null ? null : consumer.getFilter());
        Integer priority = this.selectPriority();
        return new AMQPBridgeReceiverInfo(AMQPBridgeReceiverInfo.ReceiverRole.QUEUE_RECEIVER, queue.getAddress().toString(), queue.getName().toString(), queue.getRoutingType(), remoteAddressBuilder.toString(), filterString, priority);
    }

    private Integer selectPriority() {
        if (this.configuration.isReceiverPriorityDisabled()) {
            return null;
        }
        if (this.policy.getPriority() != null) {
            return this.policy.getPriority();
        }
        return ActiveMQDefaultConfiguration.getDefaultConsumerPriority() + this.policy.getPriorityAdjustment();
    }

    private static String selectFilter(String policyFilter, Filter queueFilter, Filter consumerFilter) {
        if (policyFilter != null && !policyFilter.isBlank()) {
            return policyFilter;
        }
        if (consumerFilter != null) {
            return consumerFilter.getFilterString().toString();
        }
        return queueFilter != null ? queueFilter.getFilterString().toString() : null;
    }

    private static class AMQPBridgeQueueReceiverManager
    extends AMQPBridgeReceiverManager<ServerConsumer> {
        private final AMQPBridgeFromQueuePolicyManager manager;
        private final Queue queue;
        private final AMQPBridgeReceiverInfo receiverInfo;
        private final String receiverInfoKey;

        AMQPBridgeQueueReceiverManager(AMQPBridgeFromQueuePolicyManager manager, String receiverInfoKey, AMQPBridgeReceiverConfiguration configuration, AMQPBridgeReceiverInfo receiverInfo, Queue queue) {
            super(manager, configuration);
            this.manager = manager;
            this.queue = queue;
            this.receiverInfo = receiverInfo;
            this.receiverInfoKey = receiverInfoKey;
        }

        public String getQueueName() {
            return this.queue.getName().toString();
        }

        @Override
        protected AMQPBridgeReceiver createBridgeReceiver() {
            return this.manager.createBridgeReceiver(this.receiverInfo);
        }

        @Override
        protected void whenDemandTrackingEntryAdded(ServerConsumer consumer) {
            consumer.addAttachment(this.receiverInfoKey, (Object)this.receiverInfo);
        }

        @Override
        protected void whenDemandTrackingEntryRemoved(ServerConsumer consumer) {
            consumer.removeAttachment(this.receiverInfoKey);
        }
    }
}

