/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidJMSThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(QpidJMSThreadFactory.class);
    private final String threadName;
    private final boolean daemon;
    private final AtomicReference<Thread> threadTracker;

    public QpidJMSThreadFactory(String threadName, boolean daemon) {
        this.threadName = threadName;
        this.daemon = daemon;
        this.threadTracker = null;
    }

    public QpidJMSThreadFactory(String threadName, boolean daemon, AtomicReference<Thread> threadTracker) {
        this.threadName = threadName;
        this.daemon = daemon;
        this.threadTracker = threadTracker;
    }

    @Override
    public Thread newThread(final Runnable target) {
        Runnable runner = target;
        if (this.threadTracker != null) {
            runner = new Runnable(){

                @Override
                public void run() {
                    QpidJMSThreadFactory.this.threadTracker.set(Thread.currentThread());
                    try {
                        target.run();
                    }
                    finally {
                        QpidJMSThreadFactory.this.threadTracker.set(null);
                    }
                }
            };
        }
        Thread thread = new Thread(runner, this.threadName);
        thread.setDaemon(this.daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread target, Throwable error) {
                LOG.warn("Thread: {} failed due to an uncaught exception: {}", (Object)target.getName(), (Object)error.getMessage());
                LOG.trace("Uncaught Stacktrace: ", error);
            }
        });
        return thread;
    }
}

