/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.cli.kahadb.exporter;

import com.google.common.collect.Lists;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.Option;
import io.airlift.airline.OptionType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.activemq.cli.artemis.schema.ArtemisJournalMarshaller;
import org.apache.activemq.cli.kahadb.exporter.ExportConfiguration;
import org.apache.activemq.cli.kahadb.exporter.KahaDBExporter;
import org.apache.activemq.cli.kahadb.exporter.artemis.ArtemisXmlMessageRecoveryListener;
import org.apache.activemq.cli.kahadb.exporter.artemis.ArtemisXmlMetadataExporter;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exporter {
    static final Logger LOG = LoggerFactory.getLogger(Exporter.class);

    public static void main(String[] args) {
        Cli.CliBuilder builder = Cli.builder((String)"export").withDescription("Export a KahaDB or MultiKahaDB store to Artemis XML").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ExportKahaDb.class, ExportMultiKahaDb.class});
        Cli gitParser = builder.build();
        ((Runnable)gitParser.parse(args)).run();
    }

    public static void exportStore(ExportConfiguration config) throws Exception {
        if (!config.isOverwrite() && config.getTarget().exists()) {
            throw new IllegalStateException("File: " + config.getTarget() + " already exists");
        }
        long start = System.currentTimeMillis();
        try (BufferedOutputStream fos = new BufferedOutputStream(config.isCompress() ? new GZIPOutputStream(new FileOutputStream(config.getTarget())) : new FileOutputStream(config.getTarget()));){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(fos);
            ArtemisJournalMarshaller xmlMarshaller = new ArtemisJournalMarshaller(xmlWriter);
            xmlMarshaller.appendJournalOpen();
            if (config.isMultiKaha()) {
                Exporter.appendMultiKahaDbStore(xmlMarshaller, Exporter.getMultiKahaDbAdapter(config.getSource()), config);
            } else {
                Exporter.appendKahaDbStore(xmlMarshaller, Exporter.getKahaDbAdapter(config.getSource()), config);
            }
            xmlMarshaller.appendJournalClose(true);
        }
        long end = System.currentTimeMillis();
        LOG.info("Total export time: " + (end - start) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendMultiKahaDbStore(ArtemisJournalMarshaller xmlMarshaller, MultiKahaDBPersistenceAdapter multiAdapter, ExportConfiguration config) throws Exception {
        try {
            multiAdapter.start();
            List dbExporters = multiAdapter.getAdapters().stream().filter(adapter -> adapter instanceof KahaDBPersistenceAdapter).map(adapter -> {
                KahaDBPersistenceAdapter kahaAdapter = (KahaDBPersistenceAdapter)adapter;
                return new KahaDBExporter(kahaAdapter, new ArtemisXmlMetadataExporter(kahaAdapter.getStore(), xmlMarshaller, config), new ArtemisXmlMessageRecoveryListener(kahaAdapter.getStore(), xmlMarshaller));
            }).collect(Collectors.toList());
            xmlMarshaller.appendBindingsElement();
            for (KahaDBExporter dbExporter : dbExporters) {
                dbExporter.exportMetadata();
            }
            xmlMarshaller.appendEndElement();
            xmlMarshaller.appendMessagesElement();
            for (KahaDBExporter dbExporter : dbExporters) {
                dbExporter.exportQueues(config.getQueuePattern());
                dbExporter.exportTopics(config.getTopicPattern());
            }
            xmlMarshaller.appendEndElement();
        }
        finally {
            multiAdapter.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendKahaDbStore(ArtemisJournalMarshaller xmlMarshaller, KahaDBPersistenceAdapter adapter, ExportConfiguration config) throws Exception {
        try {
            adapter.start();
            KahaDBExporter dbExporter = new KahaDBExporter(adapter, new ArtemisXmlMetadataExporter(adapter.getStore(), xmlMarshaller, config), new ArtemisXmlMessageRecoveryListener(adapter.getStore(), xmlMarshaller));
            xmlMarshaller.appendBindingsElement();
            dbExporter.exportMetadata();
            xmlMarshaller.appendEndElement();
            xmlMarshaller.appendMessagesElement();
            dbExporter.exportQueues(config.getQueuePattern());
            dbExporter.exportTopics(config.getTopicPattern());
            xmlMarshaller.appendEndElement();
        }
        finally {
            adapter.stop();
        }
    }

    private static KahaDBPersistenceAdapter getKahaDbAdapter(File dir) {
        KahaDBPersistenceAdapter adapter = new KahaDBPersistenceAdapter();
        adapter.setDirectory(dir);
        return adapter;
    }

    private static MultiKahaDBPersistenceAdapter getMultiKahaDbAdapter(File dir) {
        MultiKahaDBPersistenceAdapter adapter = new MultiKahaDBPersistenceAdapter();
        adapter.setDirectory(dir);
        KahaDBPersistenceAdapter kahaStore = new KahaDBPersistenceAdapter();
        kahaStore.setDirectory(dir);
        FilteredKahaDBPersistenceAdapter filtered = new FilteredKahaDBPersistenceAdapter();
        filtered.setPersistenceAdapter((PersistenceAdapter)kahaStore);
        filtered.setPerDestination(true);
        adapter.setFilteredPersistenceAdapters((List)Lists.newArrayList((Object[])new FilteredKahaDBPersistenceAdapter[]{filtered}));
        return adapter;
    }

    @Command(name="mkahadb", description="Export a MultiKahaDb store to Artemis XML")
    public static class ExportMultiKahaDb
    extends ExportKahaDb {
        @Override
        public void run() {
            LOG.info("Starting MultiKahaDB store export");
            try {
                Exporter.exportStore(ExportConfiguration.ExportConfigurationBuilder.newBuilder().setMultiKaha(true).setSource(new File(this.source)).setTarget(new File(this.target)).setQueuePattern(this.queuePattern).setTopicPattern(this.topicPattern).setVirtualTopicConsumerWildcards(this.virtualTopicConsumerWildcards).setCompress(this.compress).setOverwrite(this.overwrite).build());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    @Command(name="kahadb", description="Export a KahaDb store to Artemis XML")
    public static class ExportKahaDb
    implements Runnable {
        @Option(name={"-s", "--source"}, required=true, type=OptionType.COMMAND, description="Data store directory location")
        public String source;
        @Option(name={"-t", "--target"}, required=true, type=OptionType.COMMAND, description="Xml output file location")
        public String target;
        @Option(name={"--qp", "--queuePattern"}, type=OptionType.COMMAND, description="Queue Export Pattern")
        public String queuePattern;
        @Option(name={"--tp", "--topicPattern"}, type=OptionType.COMMAND, description="Topic Export Pattern")
        public String topicPattern;
        @Option(name={"-c"}, type=OptionType.COMMAND, description="Compress output xml file using gzip")
        public boolean compress;
        @Option(name={"-f"}, type=OptionType.COMMAND, description="Force XML output and overwrite existing file")
        public boolean overwrite;
        @Option(name={"--vt", "--virtualTopicConsumerWildcards"}, type=OptionType.COMMAND, description="Virtual Topic Consumer Pattern list")
        public String virtualTopicConsumerWildcards;

        @Override
        public void run() {
            LOG.info("Starting KahaDB store export");
            try {
                Exporter.exportStore(ExportConfiguration.ExportConfigurationBuilder.newBuilder().setSource(new File(this.source)).setTarget(new File(this.target)).setQueuePattern(this.queuePattern).setTopicPattern(this.topicPattern).setVirtualTopicConsumerWildcards(this.virtualTopicConsumerWildcards).setCompress(this.compress).setOverwrite(this.overwrite).build());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

