/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.store.kahadb.disk.page.Transaction;

public class KahaDBUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SubscriptionInfo> getUnackedSubscriptions(final KahaDBStore store, Message message) throws Exception {
        final ArrayList<SubscriptionInfo> matching = new ArrayList<SubscriptionInfo>();
        if (!message.getDestination().isTopic()) {
            return matching;
        }
        final ActiveMQTopic topic = (ActiveMQTopic)message.getDestination();
        final String messageId = message.getMessageId().toString();
        TopicMessageStore messageStore = store.createTopicMessageStore(topic);
        store.indexLock.writeLock().lock();
        final SubscriptionInfo[] infos = messageStore.getAllSubscriptions();
        try {
            store.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<Exception>(){

                public void execute(Transaction tx) throws Exception {
                    MessageDatabase.StoredDestination sd = store.getStoredDestination(store.convert((ActiveMQDestination)topic), tx);
                    if (sd != null) {
                        Long position = (Long)sd.messageIdIndex.get(tx, (Object)messageId);
                        for (SubscriptionInfo info : infos) {
                            MessageDatabase.LastAck cursorPos = store.getLastAck(tx, sd, store.subscriptionKey(info.getClientId(), info.getSubcriptionName()));
                            if (cursorPos.lastAckedSequence >= position) continue;
                            matching.add(info);
                        }
                    }
                }
            });
        }
        finally {
            store.indexLock.writeLock().unlock();
        }
        return matching;
    }
}

