/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.utils.UUID;
import org.jboss.logging.Logger;

public class FileLockNodeManager
extends NodeManager {
    private static final Logger logger = Logger.getLogger(FileLockNodeManager.class);
    private static final int STATE_LOCK_POS = 0;
    private static final int LIVE_LOCK_POS = 1;
    private static final int BACKUP_LOCK_POS = 2;
    private static final long LOCK_LENGTH = 1L;
    private static final byte LIVE = 76;
    private static final byte FAILINGBACK = 70;
    private static final byte PAUSED = 80;
    private static final byte NOT_STARTED = 78;
    private static final long LOCK_ACCESS_FAILURE_WAIT_TIME = 2000L;
    private static final int LOCK_MONITOR_TIMEOUT_MILLIES = 2000;
    private volatile FileLock liveLock;
    private FileLock backupLock;
    private final FileChannel[] lockChannels = new FileChannel[3];
    protected long lockAcquisitionTimeout = -1L;
    protected boolean interrupted = false;
    private ScheduledExecutorService scheduledPool;
    protected final Set<LockListener> lockListeners = Collections.synchronizedSet(new HashSet());
    private MonitorLock monitorLock;

    public FileLockNodeManager(File directory, boolean replicatedBackup, ScheduledExecutorService scheduledPool) {
        super(replicatedBackup, directory);
        this.scheduledPool = scheduledPool;
    }

    public FileLockNodeManager(File directory, boolean replicatedBackup) {
        super(replicatedBackup, directory);
        this.scheduledPool = null;
    }

    public FileLockNodeManager(File directory, boolean replicatedBackup, long lockAcquisitionTimeout, ScheduledExecutorService scheduledPool) {
        super(replicatedBackup, directory);
        this.scheduledPool = scheduledPool;
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        if (!this.replicatedBackup) {
            this.setUpServerLockFile();
        }
        super.start();
    }

    @Override
    protected synchronized void setUpServerLockFile() throws IOException {
        super.setUpServerLockFile();
        this.lockChannels[0] = this.channel;
        for (int i = 1; i < 3; ++i) {
            if (this.lockChannels[i] != null && this.lockChannels[i].isOpen()) continue;
            File fileLock = this.newFile("serverlock." + i);
            if (!fileLock.exists()) {
                fileLock.createNewFile();
            }
            RandomAccessFile randomFileLock = new RandomAccessFile(fileLock, "rw");
            this.lockChannels[i] = randomFileLock.getChannel();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        for (FileChannel channel : this.lockChannels) {
            if (channel == null || !channel.isOpen()) continue;
            try {
                channel.close();
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
        }
        super.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.getState() == 70;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        FileLock liveAttemptLock = this.tryLock(1);
        if (liveAttemptLock == null) {
            return true;
        }
        liveAttemptLock.release();
        return false;
    }

    public boolean isLiveLocked() {
        return this.liveLock != null;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public final void releaseBackup() throws Exception {
        if (this.backupLock != null) {
            this.backupLock.release();
            this.backupLock = null;
        }
    }

    @Override
    public void awaitLiveNode() throws Exception {
        byte state;
        logger.debug((Object)"awaiting live node...");
        while (true) {
            state = this.getState();
            while (state == 78 || state == 48) {
                logger.debug((Object)("awaiting live node startup state='" + state + "'"));
                Thread.sleep(2000L);
                state = this.getState();
            }
            this.liveLock = this.lock(1);
            if (this.interrupted) {
                this.interrupted = false;
                throw new InterruptedException("Lock was interrupted");
            }
            state = this.getState();
            if (state == 80) {
                this.liveLock.release();
                logger.debug((Object)"awaiting live node restarting");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 70) {
                this.liveLock.release();
                logger.debug((Object)"awaiting live node failing back");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 76) break;
        }
        logger.debug((Object)("acquired live node lock state = " + (char)state));
    }

    @Override
    public void startBackup() throws Exception {
        assert (!this.replicatedBackup);
        ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
        this.backupLock = this.lock(2);
        ActiveMQServerLogger.LOGGER.gotBackupLock();
        if (this.getUUID() == null) {
            this.readNodeId();
        }
    }

    @Override
    public ActivateCallback startLiveNode() throws Exception {
        this.setFailingBack();
        String timeoutMessage = this.lockAcquisitionTimeout == -1L ? "indefinitely" : this.lockAcquisitionTimeout + " milliseconds";
        ActiveMQServerLogger.LOGGER.waitingToObtainLiveLock(timeoutMessage);
        this.liveLock = this.lock(1);
        ActiveMQServerLogger.LOGGER.obtainedLiveLock();
        return new CleaningActivateCallback(){

            @Override
            public void activationComplete() {
                try {
                    FileLockNodeManager.this.setLive();
                    FileLockNodeManager.this.startLockMonitoring();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
        };
    }

    @Override
    public void pauseLiveServer() throws Exception {
        this.stopLockMonitoring();
        this.setPaused();
        if (this.liveLock != null) {
            this.liveLock.release();
        }
    }

    @Override
    public void crashLiveServer() throws Exception {
        this.stopLockMonitoring();
        if (this.liveLock != null) {
            this.liveLock.release();
            this.liveLock = null;
        }
    }

    @Override
    public void awaitLiveStatus() throws Exception {
        while (this.getState() != 76) {
            Thread.sleep(2000L);
        }
    }

    private void setLive() throws Exception {
        this.writeFileLockStatus((byte)76);
    }

    private void setFailingBack() throws Exception {
        this.writeFileLockStatus((byte)70);
    }

    private void setPaused() throws Exception {
        this.writeFileLockStatus((byte)80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileLockStatus(byte status) throws Exception {
        if (this.replicatedBackup && this.channel == null) {
            return;
        }
        logger.debug((Object)("writing status: " + status));
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put(status);
        bb.position(0);
        if (!this.channel.isOpen()) {
            this.setUpServerLockFile();
        }
        FileLock lock = null;
        try {
            lock = this.lock(0);
            this.channel.write(bb, 0L);
            this.channel.force(true);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte getState() throws Exception {
        byte result;
        logger.debug((Object)"getting state...");
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        FileLock lock = null;
        try {
            lock = this.lock(0);
            int read = this.channel.read(bb, 0L);
            result = read <= 0 ? (byte)78 : (byte)bb.get(0);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        logger.debug((Object)("state: " + result));
        return result;
    }

    @Override
    public final SimpleString readNodeId() throws ActiveMQIllegalStateException, IOException {
        ByteBuffer id = ByteBuffer.allocateDirect(16);
        int read = this.channel.read(id, 3L);
        if (read != 16) {
            throw new ActiveMQIllegalStateException("live server did not write id to file");
        }
        byte[] bytes = new byte[16];
        id.position(0);
        id.get(bytes);
        this.setUUID(new UUID(1, bytes));
        return this.getNodeId();
    }

    protected FileLock tryLock(int lockPos) throws IOException {
        try {
            logger.debug((Object)("trying to lock position: " + lockPos));
            FileLock lock = this.lockChannels[lockPos].tryLock();
            if (lock != null) {
                logger.debug((Object)("locked position: " + lockPos));
            } else {
                logger.debug((Object)("failed to lock position: " + lockPos));
            }
            return lock;
        }
        catch (OverlappingFileLockException ex) {
            return null;
        }
    }

    protected FileLock lock(int lockPosition) throws Exception {
        long start = System.currentTimeMillis();
        boolean isRecurringFailure = false;
        while (!this.interrupted) {
            try {
                FileLock lock = this.tryLock(lockPosition);
                isRecurringFailure = false;
                if (lock == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    if (this.lockAcquisitionTimeout == -1L || System.currentTimeMillis() - start <= this.lockAcquisitionTimeout) continue;
                    throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
                }
                return lock;
            }
            catch (IOException e) {
                logger.log(isRecurringFailure ? Logger.Level.DEBUG : Logger.Level.WARN, (Object)"Failure when accessing a lock file", (Throwable)e);
                isRecurringFailure = true;
                long waitTime = 2000L;
                if (this.lockAcquisitionTimeout != -1L) {
                    long remainingTime = this.lockAcquisitionTimeout - (System.currentTimeMillis() - start);
                    if (remainingTime <= 0L) {
                        throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
                    }
                    waitTime = Math.min(waitTime, remainingTime);
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interrupt) {
                    return null;
                }
            }
        }
        return null;
    }

    private synchronized void startLockMonitoring() {
        logger.debug((Object)"Starting the lock monitor");
        if (this.monitorLock == null) {
            this.monitorLock = new MonitorLock(this.scheduledPool, 2000L, 2000L, TimeUnit.MILLISECONDS, false);
            this.monitorLock.start();
        } else {
            logger.debug((Object)"Lock monitor was already started");
        }
    }

    private synchronized void stopLockMonitoring() {
        logger.debug((Object)"Stopping the lock monitor");
        if (this.monitorLock != null) {
            this.monitorLock.stop();
            this.monitorLock = null;
        } else {
            logger.debug((Object)"The lock monitor was already stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLostLock() {
        if (this.lockListeners != null && this.liveLock != null) {
            HashSet<LockListener> lockListenersSnapshot = null;
            Set<LockListener> set = this.lockListeners;
            synchronized (set) {
                lockListenersSnapshot = new HashSet<LockListener>(this.lockListeners);
            }
            lockListenersSnapshot.forEach(lockListener -> {
                try {
                    lockListener.lostLock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public void registerLockListener(LockListener lockListener) {
        this.lockListeners.add(lockListener);
    }

    public void unregisterLockListener(LockListener lockListener) {
        this.lockListeners.remove(lockListener);
    }

    public class MonitorLock
    extends ActiveMQScheduledComponent {
        public MonitorLock(ScheduledExecutorService scheduledExecutorService, long initialDelay, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, initialDelay, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            boolean lostLock = true;
            try {
                if (FileLockNodeManager.this.liveLock == null) {
                    logger.debug((Object)"Livelock is null");
                }
                boolean bl = lostLock = FileLockNodeManager.this.liveLock != null && !FileLockNodeManager.this.liveLock.isValid() || FileLockNodeManager.this.liveLock == null;
                if (!lostLock) {
                    logger.debug((Object)"Server still has the lock, double check status is live");
                    byte state = FileLockNodeManager.this.getState();
                    if (state == 76) {
                        logger.debug((Object)"Status is set to live");
                    } else {
                        logger.debug((Object)"Status is not live");
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                lostLock = true;
            }
            if (lostLock) {
                logger.warn((Object)"Lost the lock according to the monitor, notifying listeners");
                FileLockNodeManager.this.notifyLostLock();
            }
        }
    }

    public abstract class LockListener {
        protected abstract void lostLock() throws Exception;

        protected void unregisterListener() {
            FileLockNodeManager.this.lockListeners.remove(this);
        }
    }
}

