/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.management;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.grpc.Context;
import jakarta.persistence.EntityNotFoundException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.iam.api.AddExternalIDPLinksRequest;
import org.apache.custos.core.iam.api.AddUserAttributesRequest;
import org.apache.custos.core.iam.api.AddUserRolesRequest;
import org.apache.custos.core.iam.api.CheckingResponse;
import org.apache.custos.core.iam.api.DeleteExternalIDPsRequest;
import org.apache.custos.core.iam.api.DeleteUserAttributeRequest;
import org.apache.custos.core.iam.api.DeleteUserRolesRequest;
import org.apache.custos.core.iam.api.FindUsersRequest;
import org.apache.custos.core.iam.api.FindUsersResponse;
import org.apache.custos.core.iam.api.GetAllResources;
import org.apache.custos.core.iam.api.GetAllResourcesResponse;
import org.apache.custos.core.iam.api.GetExternalIDPsRequest;
import org.apache.custos.core.iam.api.GetExternalIDPsResponse;
import org.apache.custos.core.iam.api.OperationStatus;
import org.apache.custos.core.iam.api.RegisterUserRequest;
import org.apache.custos.core.iam.api.RegisterUserResponse;
import org.apache.custos.core.iam.api.RegisterUsersRequest;
import org.apache.custos.core.iam.api.RegisterUsersResponse;
import org.apache.custos.core.iam.api.ResetUserPassword;
import org.apache.custos.core.iam.api.ResourceTypes;
import org.apache.custos.core.iam.api.UpdateUserProfileRequest;
import org.apache.custos.core.iam.api.UserAttribute;
import org.apache.custos.core.iam.api.UserRepresentation;
import org.apache.custos.core.iam.api.UserSearchMetadata;
import org.apache.custos.core.iam.api.UserSearchRequest;
import org.apache.custos.core.identity.api.AuthToken;
import org.apache.custos.core.identity.api.GetUserManagementSATokenRequest;
import org.apache.custos.core.user.management.api.LinkUserProfileRequest;
import org.apache.custos.core.user.management.api.SynchronizeUserDBRequest;
import org.apache.custos.core.user.profile.api.GetAllUserProfilesResponse;
import org.apache.custos.core.user.profile.api.GetUpdateAuditTrailRequest;
import org.apache.custos.core.user.profile.api.GetUpdateAuditTrailResponse;
import org.apache.custos.core.user.profile.api.UserProfile;
import org.apache.custos.core.user.profile.api.UserProfileRequest;
import org.apache.custos.core.user.profile.api.UserStatus;
import org.apache.custos.service.exceptions.AuthenticationException;
import org.apache.custos.service.exceptions.InternalServerException;
import org.apache.custos.service.iam.IamAdminService;
import org.apache.custos.service.identity.IdentityService;
import org.apache.custos.service.profile.UserProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManagementService.class);
    private final UserProfileService userProfileService;
    private final IdentityService identityService;
    private final IamAdminService iamAdminService;

    public UserManagementService(UserProfileService userProfileService, IdentityService identityService, IamAdminService iamAdminService) {
        this.userProfileService = userProfileService;
        this.identityService = identityService;
        this.iamAdminService = iamAdminService;
    }

    public RegisterUserResponse registerUser(RegisterUserRequest request) {
        try {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                RegisterUserRequest registerUserRequest = request.toBuilder().setAccessToken(token.getAccessToken()).build();
                return this.iamAdminService.registerUser(registerUserRequest);
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token when registering the user");
        }
        catch (Exception ex) {
            String msg = "Error occurred while registering users,  " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("CredentialGenerationException")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public RegisterUsersResponse registerAndEnableUsers(RegisterUsersRequest request) {
        try {
            RegisterUsersResponse registerUsersResponse = this.iamAdminService.registerAndEnableUsers(request);
            if (!request.getUsersList().isEmpty() && registerUsersResponse.getAllUseresRegistered()) {
                try {
                    request.getUsersList().forEach(user -> {
                        ArrayList userAtrList = new ArrayList();
                        if (!user.getAttributesList().isEmpty()) {
                            user.getAttributesList().forEach(atr -> {
                                org.apache.custos.core.user.profile.api.UserAttribute userAttribute = org.apache.custos.core.user.profile.api.UserAttribute.newBuilder().setKey(atr.getKey()).addAllValues((Iterable)atr.getValuesList()).build();
                                userAtrList.add(userAttribute);
                            });
                        }
                        UserProfile profile = UserProfile.newBuilder().setFirstName(user.getFirstName()).setLastName(user.getLastName()).setEmail(user.getEmail()).setStatus(UserStatus.ACTIVE).addAllAttributes(userAtrList).addAllRealmRoles((Iterable)user.getRealmRolesList()).addAllClientRoles((Iterable)user.getClientRolesList()).setUsername(user.getUsername().toLowerCase()).build();
                        UserProfileRequest profileRequest = UserProfileRequest.newBuilder().setProfile(profile).setTenantId(request.getTenantId()).build();
                        this.userProfileService.createUserProfile(profileRequest);
                    });
                }
                catch (Exception ex) {
                    request.getUsersList().forEach(user -> {
                        UserSearchMetadata metadata = UserSearchMetadata.newBuilder().setUsername(user.getUsername()).build();
                        UserSearchRequest searchRequest = UserSearchRequest.newBuilder().setTenantId(request.getTenantId()).setClientId(request.getClientId()).setAccessToken(request.getAccessToken()).setUser(metadata).build();
                        this.iamAdminService.deleteUser(searchRequest);
                    });
                }
            }
            return registerUsersResponse;
        }
        catch (Exception ex) {
            String msg = "Error occurred while registering and enabling  users,  " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus addUserAttributes(AddUserAttributesRequest request) {
        try {
            OperationStatus status = this.iamAdminService.addUserAttributes(request);
            for (String user : request.getUsersList()) {
                UserSearchMetadata metadata = UserSearchMetadata.newBuilder().setUsername(user).build();
                UserSearchRequest searchRequest = UserSearchRequest.newBuilder().setClientId(request.getClientId()).setTenantId(request.getTenantId()).setAccessToken(request.getAccessToken()).setUser(metadata).build();
                UserRepresentation representation = this.iamAdminService.getUser(searchRequest);
                if (representation == null) continue;
                UserProfile profile = this.convertToProfile(representation);
                UserProfileRequest req = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setProfile(profile).build();
                UserProfile existingProfile = this.userProfileService.getUserProfile(req);
                if (existingProfile == null || StringUtils.isBlank((CharSequence)existingProfile.getUsername())) {
                    this.userProfileService.createUserProfile(req);
                    continue;
                }
                this.userProfileService.updateUserProfile(req);
            }
            return status;
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding user attributes, " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus deleteUserAttributes(DeleteUserAttributeRequest request) {
        try {
            OperationStatus status = this.iamAdminService.deleteUserAttributes(request);
            for (String user : request.getUsersList()) {
                UserSearchMetadata metadata = UserSearchMetadata.newBuilder().setUsername(user).build();
                UserSearchRequest searchRequest = UserSearchRequest.newBuilder().setClientId(request.getClientId()).setTenantId(request.getTenantId()).setAccessToken(request.getAccessToken()).setUser(metadata).build();
                UserRepresentation representation = this.iamAdminService.getUser(searchRequest);
                if (representation == null) continue;
                UserProfile profile = this.convertToProfile(representation);
                UserProfileRequest req = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setProfile(profile).build();
                this.userProfileService.updateUserProfile(req);
            }
            return status;
        }
        catch (Exception ex) {
            String msg = "Error occurred while deleting user attributes " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public UserRepresentation enableUser(UserSearchRequest request) {
        try {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                UserRepresentation user = this.iamAdminService.enableUser(request = request.toBuilder().setAccessToken(token.getAccessToken()).build());
                if (user != null) {
                    UserProfile profile = this.convertToProfile(user);
                    UserProfileRequest profileRequest = UserProfileRequest.newBuilder().setProfile(profile).setTenantId(request.getTenantId()).build();
                    UserProfile exProfile = this.userProfileService.getUserProfile(profileRequest);
                    if (StringUtils.isBlank((CharSequence)exProfile.getUsername())) {
                        this.userProfileService.createUserProfile(profileRequest);
                    } else {
                        this.userProfileService.updateUserProfile(profileRequest);
                    }
                    return user;
                }
                String msg = "User enabling failed at IDP server";
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token");
        }
        catch (Exception ex) {
            String msg = "Error occurred while enabling user, " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public UserRepresentation disableUser(UserSearchRequest request) {
        try {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                UserRepresentation user = this.iamAdminService.disableUser(request = request.toBuilder().setAccessToken(token.getAccessToken()).build());
                if (user != null) {
                    UserProfile profile = this.convertToProfile(user);
                    UserProfileRequest profileRequest = UserProfileRequest.newBuilder().setProfile(profile).setTenantId(request.getTenantId()).build();
                    UserProfile exProfile = this.userProfileService.getUserProfile(profileRequest);
                    if (StringUtils.isBlank((CharSequence)exProfile.getUsername())) {
                        this.userProfileService.createUserProfile(profileRequest);
                    } else {
                        this.userProfileService.updateUserProfile(profileRequest);
                    }
                    return user;
                }
                String msg = "User enabling failed at IDP server";
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token");
        }
        catch (Exception ex) {
            String msg = "Error occurred while disabling user, " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus deleteUser(UserSearchRequest request) {
        try {
            UserProfile profileReq = UserProfile.newBuilder().setUsername(request.getUser().getUsername().toLowerCase()).build();
            UserProfileRequest req = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setProfile(profileReq).build();
            UserProfile profile = this.userProfileService.getUserProfile(req);
            if (profile != null && StringUtils.isNotBlank((CharSequence)profile.getUsername())) {
                UserProfile deletedProfile = this.userProfileService.deleteUserProfile(req);
                if (deletedProfile != null) {
                    return this.iamAdminService.deleteUser(request);
                }
                String msg = "User profile deletion failed for " + request.getUser().getUsername();
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            return this.iamAdminService.deleteUser(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred while  deleting user " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public UserRepresentation getUser(UserSearchRequest request) {
        try {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                request = request.toBuilder().setAccessToken(token.getAccessToken()).build();
                return this.iamAdminService.getUser(request);
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token");
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching user, " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            if (ex.getMessage().contains("NOT_FOUND")) {
                throw new EntityNotFoundException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public FindUsersResponse findUsers(FindUsersRequest request) {
        try {
            long initiationTime = System.currentTimeMillis();
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && token.getAccessToken() != null) {
                request = request.toBuilder().setAccessToken(token.getAccessToken()).build();
                FindUsersResponse user = this.iamAdminService.findUsers(request);
                long endTime = System.currentTimeMillis();
                long total = endTime - initiationTime;
                LOGGER.debug("request received: " + initiationTime + " request end time" + endTime + " difference " + total);
                return user;
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token");
        }
        catch (Exception ex) {
            String msg = "Error occurred while pulling users, " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus resetPassword(ResetUserPassword request) {
        try {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                request = request.toBuilder().setAccessToken(token.getAccessToken()).build();
                return this.iamAdminService.resetPassword(request);
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token");
        }
        catch (Exception ex) {
            String msg = "Error occurred  while resetting password " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus addRolesToUsers(AddUserRolesRequest request) {
        try {
            OperationStatus response = this.iamAdminService.addRolesToUsers(request);
            for (String user : request.getUsernamesList()) {
                UserSearchMetadata metadata = UserSearchMetadata.newBuilder().setUsername(user).build();
                UserSearchRequest searchRequest = UserSearchRequest.newBuilder().setClientId(request.getClientId()).setTenantId(request.getTenantId()).setAccessToken(request.getAccessToken()).setUser(metadata).build();
                UserRepresentation representation = this.iamAdminService.getUser(searchRequest);
                if (representation == null) continue;
                UserProfile profile = this.convertToProfile(representation);
                UserProfileRequest req = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setProfile(profile).build();
                UserProfile existingUser = this.userProfileService.getUserProfile(req);
                if (existingUser == null || StringUtils.isBlank((CharSequence)existingUser.getUsername())) {
                    this.userProfileService.createUserProfile(req);
                    continue;
                }
                this.userProfileService.updateUserProfile(req);
            }
            return response;
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding roles to users, " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus deleteUserRoles(DeleteUserRolesRequest request) {
        try {
            OperationStatus response = this.iamAdminService.deleteRolesFromUser(request);
            UserSearchMetadata metadata = UserSearchMetadata.newBuilder().setUsername(request.getUsername()).build();
            UserSearchRequest searchRequest = UserSearchRequest.newBuilder().setClientId(request.getClientId()).setTenantId(request.getTenantId()).setAccessToken(request.getAccessToken()).setUser(metadata).build();
            UserRepresentation representation = this.iamAdminService.getUser(searchRequest);
            if (representation != null) {
                UserProfile profile = this.convertToProfile(representation);
                UserProfileRequest req = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setProfile(profile).build();
                this.userProfileService.updateUserProfile(req);
            }
            return response;
        }
        catch (Exception ex) {
            String msg = "Error occurred while delete user roles,  " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus isUserEnabled(UserSearchRequest request) {
        try {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                request = request.toBuilder().setAccessToken(token.getAccessToken()).build();
                return this.iamAdminService.isUserEnabled(request);
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token");
        }
        catch (Exception ex) {
            String msg = "Error occurred while enabling user " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus isUsernameAvailable(UserSearchRequest request) {
        try {
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getClientId()).setClientSecret(request.getClientSec()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                request = request.toBuilder().setAccessToken(token.getAccessToken()).build();
                return this.iamAdminService.isUsernameAvailable(request);
            }
            LOGGER.error("Cannot find service token");
            throw new RuntimeException("Cannot find service token");
        }
        catch (Exception ex) {
            String msg = "Error occurred while checking username, " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    /*
     * Exception decompiling
     */
    public UserProfile updateUserProfile(org.apache.custos.core.user.management.api.UserProfileRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public UserProfile deleteUserProfile(org.apache.custos.core.user.management.api.UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to deleteUserProfile " + request.getUserProfile().getUsername() + " at " + request.getTenantId());
            UserSearchMetadata metadata = UserSearchMetadata.newBuilder().setUsername(request.getUserProfile().getUsername()).build();
            UserSearchRequest info = UserSearchRequest.newBuilder().setAccessToken(request.getAccessToken()).setTenantId(request.getTenantId()).setUser(metadata).build();
            UserProfileRequest userProfileRequest = UserProfileRequest.newBuilder().setProfile(request.getUserProfile()).setTenantId(request.getTenantId()).build();
            UserProfile userProfile = this.userProfileService.deleteUserProfile(userProfileRequest);
            this.iamAdminService.deleteUser(info);
            return userProfile;
        }
        catch (Exception ex) {
            String msg = "Error occurred while deleting user profile " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public UserProfile getUserProfile(org.apache.custos.core.user.management.api.UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to getUserProfile " + request.getUserProfile().getUsername() + " at " + request.getTenantId());
            UserProfileRequest userProfileRequest = UserProfileRequest.newBuilder().setProfile(request.getUserProfile()).setTenantId(request.getTenantId()).build();
            return this.userProfileService.getUserProfile(userProfileRequest);
        }
        catch (Exception ex) {
            String msg = "Error occurred while pulling  user profile " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllUserProfilesResponse getAllUserProfilesInTenant(org.apache.custos.core.user.management.api.UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to getAllUserProfilesInTenant " + request.getTenantId() + " at " + request.getTenantId());
            UserProfileRequest userProfileRequest = UserProfileRequest.newBuilder().setProfile(request.getUserProfile()).setTenantId(request.getTenantId()).setOffset(request.getOffset()).setLimit(request.getLimit()).build();
            return request.getUserProfile().getAttributesList().isEmpty() ? this.userProfileService.getAllUserProfilesInTenant(userProfileRequest) : this.userProfileService.findUserProfilesByAttributes(userProfileRequest);
        }
        catch (Exception ex) {
            String msg = "Error occurred while pulling  all  user profiles in tenant " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetUpdateAuditTrailResponse getUserProfileAuditTrails(GetUpdateAuditTrailRequest request) {
        try {
            LOGGER.debug("Request received to getUserProfileAuditTrails " + request.getUsername() + " at " + request.getTenantId());
            return this.userProfileService.getUserProfileAuditTrails(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred while pulling user profile audit trails " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus linkUserProfile(LinkUserProfileRequest request) {
        try {
            LOGGER.debug("Request received to linkUserProfile   at " + request.getTenantId());
            GetUserManagementSATokenRequest userManagementSATokenRequest = GetUserManagementSATokenRequest.newBuilder().setClientId(request.getIamClientId()).setClientSecret(request.getIamClientSecret()).setTenantId(request.getTenantId()).build();
            AuthToken token = this.identityService.getUserManagementServiceAccountAccessToken(userManagementSATokenRequest);
            if (token != null && StringUtils.isNotBlank((CharSequence)token.getAccessToken())) {
                UserSearchMetadata metadata = UserSearchMetadata.newBuilder().setUsername(request.getCurrentUsername()).build();
                UserSearchRequest searchRequest = UserSearchRequest.newBuilder().setClientId(request.getIamClientId()).setTenantId(request.getTenantId()).setAccessToken(token.getAccessToken()).setUser(metadata).build();
                UserRepresentation userTobeLinked = this.iamAdminService.getUser(searchRequest);
                if (userTobeLinked != null && StringUtils.isNotBlank((CharSequence)userTobeLinked.getUsername())) {
                    UserSearchMetadata exMetadata = UserSearchMetadata.newBuilder().setUsername(request.getPreviousUsername()).build();
                    UserSearchRequest exSearchRequest = UserSearchRequest.newBuilder().setClientId(request.getIamClientId()).setTenantId(request.getTenantId()).setAccessToken(token.getAccessToken()).setUser(exMetadata).build();
                    UserRepresentation exRep = this.iamAdminService.getUser(exSearchRequest);
                    if (exRep != null && StringUtils.isNotBlank((CharSequence)exRep.getUsername())) {
                        UserRepresentation updatedUser;
                        boolean profileUpdate = false;
                        ArrayList<UserAttribute> userAttributeList = new ArrayList<UserAttribute>();
                        for (String attribute : request.getLinkingAttributesList()) {
                            if ("name".equals(attribute)) {
                                profileUpdate = true;
                                userTobeLinked = userTobeLinked.toBuilder().setFirstName(exRep.getFirstName()).setLastName(exRep.getLastName()).build();
                                continue;
                            }
                            if ("email".equals(attribute)) {
                                profileUpdate = true;
                                userTobeLinked = userTobeLinked.toBuilder().setEmail(exRep.getEmail()).build();
                                continue;
                            }
                            List<UserAttribute> userAttributes = exRep.getAttributesList().stream().filter(atr -> atr.getKey().equals(attribute)).toList();
                            if (userAttributes.isEmpty()) continue;
                            UserAttribute userAttribute = userAttributes.get(0);
                            userAttributeList.add(userAttribute);
                        }
                        if (profileUpdate) {
                            UpdateUserProfileRequest updateUserProfileRequest = UpdateUserProfileRequest.newBuilder().setUser(userTobeLinked).setAccessToken(token.getAccessToken()).setTenantId(request.getTenantId()).build();
                            this.iamAdminService.updateUserProfile(updateUserProfileRequest);
                        }
                        if (!userAttributeList.isEmpty()) {
                            AddUserAttributesRequest addUserAttributesRequest = AddUserAttributesRequest.newBuilder().addUsers(request.getCurrentUsername()).addAllAttributes(userAttributeList).setTenantId(request.getTenantId()).setAccessToken(token.getAccessToken()).setClientId(request.getIamClientId()).setPerformedBy(request.getPerformedBy()).build();
                            this.iamAdminService.addUserAttributes(addUserAttributesRequest);
                        }
                        if ((updatedUser = this.iamAdminService.getUser(searchRequest)) != null) {
                            UserProfile profile = this.convertToProfile(updatedUser);
                            UserProfileRequest req = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setProfile(profile).build();
                            UserProfile existingProfile = this.userProfileService.getUserProfile(req);
                            if (existingProfile == null || StringUtils.isBlank((CharSequence)existingProfile.getUsername())) {
                                this.userProfileService.createUserProfile(req);
                            } else {
                                this.userProfileService.updateUserProfile(req);
                            }
                        }
                        CheckingResponse response = CheckingResponse.newBuilder().setIsExist(true).build();
                        return OperationStatus.newBuilder().setStatus(response.getIsExist()).build();
                    }
                    String msg = "Cannot found existing user ";
                    LOGGER.error(msg);
                    throw new EntityNotFoundException(msg);
                }
                LOGGER.error("Cannot find an existing user to be linked. User name: " + request.getCurrentUsername());
                throw new EntityNotFoundException("Cannot find an existing user to be linked. User name: " + request.getCurrentUsername());
            }
            LOGGER.error("Cannot find the access token for User search request. User name: " + request.getCurrentUsername());
            throw new RuntimeException("Cannot find the access token for User search request. User name: " + request.getCurrentUsername());
        }
        catch (Exception ex) {
            String msg = "Error occurred while linking user profile in tenant " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("UNAUTHENTICATED")) {
                throw new AuthenticationException(msg, ex);
            }
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus grantAdminPrivileges(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to grantAdminPrivileges " + request.getUser().getUsername() + " at " + request.getTenantId());
            this.iamAdminService.grantAdminPrivilege(request);
            UserRepresentation representation = this.iamAdminService.getUser(request);
            if (representation != null) {
                UserProfile profile = this.convertToProfile(representation);
                UserProfileRequest profileRequest = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setPerformedBy(request.getPerformedBy()).setProfile(profile).build();
                UserProfile exProfile = this.userProfileService.getUserProfile(profileRequest);
                if (exProfile == null || StringUtils.isBlank((CharSequence)exProfile.getUsername())) {
                    this.userProfileService.createUserProfile(profileRequest);
                } else {
                    this.userProfileService.updateUserProfile(profileRequest);
                }
                return OperationStatus.newBuilder().setStatus(true).build();
            }
            String msg = "User not found. User Id: " + request.getUser().getId();
            LOGGER.error(msg);
            throw new EntityNotFoundException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred while puling user profile audit trails " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus removeAdminPrivileges(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to removeAdminPrivileges " + request.getUser().getUsername() + " at " + request.getTenantId());
            this.iamAdminService.removeAdminPrivilege(request);
            UserRepresentation representation = this.iamAdminService.getUser(request);
            if (representation != null) {
                UserProfile profile = this.convertToProfile(representation);
                UserProfileRequest profileRequest = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setPerformedBy(request.getPerformedBy()).setProfile(profile).build();
                UserProfile exProfile = this.userProfileService.getUserProfile(profileRequest);
                if (exProfile == null || StringUtils.isBlank((CharSequence)exProfile.getUsername())) {
                    this.userProfileService.createUserProfile(profileRequest);
                } else {
                    this.userProfileService.updateUserProfile(profileRequest);
                }
                return OperationStatus.newBuilder().setStatus(true).build();
            }
            String msg = "User not found. User Id: " + request.getUser().getId();
            LOGGER.error(msg);
            throw new EntityNotFoundException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred while  removing admin privileges " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus deleteExternalIDPsOfUsers(DeleteExternalIDPsRequest request) {
        try {
            LOGGER.debug("Request received to deleteExternalIDPsOfUsers for " + request.getTenantId());
            return this.iamAdminService.deleteExternalIDPLinksOfUsers(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred while  deleting external IDPs of Users " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetExternalIDPsResponse getExternalIDPsOfUsers(GetExternalIDPsRequest request) {
        try {
            LOGGER.debug("Request received to getExternalIDPs of users in " + request.getTenantId());
            return this.iamAdminService.getExternalIDPLinksOfUsers(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred while  fetching external IDPs of Users " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus addExternalIDPsOfUsers(AddExternalIDPLinksRequest request) {
        try {
            LOGGER.debug("Request received to addExternalIDPsOfUsers of users in " + request.getTenantId());
            return this.iamAdminService.addExternalIDPLinksOfUsers(request);
        }
        catch (Exception ex) {
            String msg = "Error occurred while  adding external IDPs of Users " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus synchronizeUserDBs(SynchronizeUserDBRequest request) {
        Object status = null;
        try {
            Context ctx = Context.current().fork();
            ctx.run(() -> {
                GetAllResources resources = GetAllResources.newBuilder().setClientId(request.getClientId()).setTenantId(request.getTenantId()).setResourceType(ResourceTypes.USER).build();
                GetAllResourcesResponse response = this.iamAdminService.getAllResources(resources);
                if (response != null && !response.getUsersList().isEmpty()) {
                    for (UserRepresentation userRepresentation : response.getUsersList()) {
                        LOGGER.debug("User Name " + userRepresentation.getUsername());
                        UserProfile profile = this.convertToProfile(userRepresentation);
                        UserProfileRequest profileRequest = UserProfileRequest.newBuilder().setTenantId(request.getTenantId()).setPerformedBy("SYSTEM").setProfile(profile).build();
                        UserProfile exProfile = this.userProfileService.getUserProfile(profileRequest);
                        if (exProfile == null || StringUtils.isBlank((CharSequence)exProfile.getUsername())) {
                            this.userProfileService.createUserProfile(profileRequest);
                            continue;
                        }
                        this.userProfileService.updateUserProfile(profileRequest);
                    }
                } else {
                    LOGGER.debug("Empty");
                }
            });
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred at synchronizeAgentDBs " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Map<String, Object> getUserInfo(String accessToken, long tenantId) {
        try {
            Map<String, Object> userInfo = this.iamAdminService.getUserInfo(accessToken, tenantId);
            SignedJWT signedJWT = SignedJWT.parse((String)accessToken);
            JWTClaimsSet claims = signedJWT.getJWTClaimsSet();
            userInfo.put("groups", claims.getClaim("groups"));
            userInfo.put("scopes", claims.getClaim("scopes"));
            return userInfo;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error while extracting userinfo");
        }
    }

    private UserProfile convertToProfile(UserRepresentation representation) {
        UserProfile.Builder profileBuilder = UserProfile.newBuilder();
        if (representation.getRealmRolesCount() > 0) {
            profileBuilder.addAllRealmRoles((Iterable)representation.getRealmRolesList());
        }
        if (representation.getClientRolesCount() > 0) {
            profileBuilder.addAllClientRoles((Iterable)representation.getClientRolesList());
        }
        if (representation.getAttributesCount() > 0) {
            List attributeList = representation.getAttributesList();
            ArrayList userAtrList = new ArrayList();
            attributeList.forEach(atr -> {
                org.apache.custos.core.user.profile.api.UserAttribute userAttribute = org.apache.custos.core.user.profile.api.UserAttribute.newBuilder().setKey(atr.getKey()).addAllValues((Iterable)atr.getValuesList()).build();
                userAtrList.add(userAttribute);
            });
            profileBuilder.addAllAttributes(userAtrList);
        }
        profileBuilder.setUsername(representation.getUsername().toLowerCase());
        profileBuilder.setFirstName(representation.getFirstName());
        profileBuilder.setLastName(representation.getLastName());
        profileBuilder.setEmail(representation.getEmail());
        return profileBuilder.build();
    }
}

