/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPathContinuation;
import org.hibernate.metamodel.mapping.ordering.ast.PathResolutionException;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.spi.NavigablePath;

public class FkDomainPathContinuation
extends DomainPathContinuation {
    private final Set<String> possiblePaths;

    public FkDomainPathContinuation(NavigablePath navigablePath, DomainPath lhs, ToOneAttributeMapping referencedModelPart) {
        super(navigablePath, lhs, referencedModelPart);
        this.possiblePaths = referencedModelPart.getTargetKeyPropertyNames();
    }

    public FkDomainPathContinuation(NavigablePath navigablePath, DomainPath lhs, ModelPart referencedModelPart, Set<String> possiblePaths) {
        super(navigablePath, lhs, referencedModelPart);
        this.possiblePaths = possiblePaths;
    }

    @Override
    public SequencePart resolvePathPart(String name, String identifier, boolean isTerminal, TranslationContext translationContext) {
        LinkedHashSet<String> furtherPaths = new LinkedHashSet<String>(this.possiblePaths.size());
        for (String path : this.possiblePaths) {
            if (!path.startsWith(name)) {
                return new DomainPathContinuation(this.navigablePath.append(name), this, this.referencedModelPart);
            }
            furtherPaths.add(path.substring(name.length() + 1));
        }
        if (furtherPaths.isEmpty()) {
            throw new PathResolutionException("Domain path of type `" + this.referencedModelPart.getPartMappingType() + "` -> `" + name + "`");
        }
        return new FkDomainPathContinuation(this.navigablePath.append(name), this, ((ModelPartContainer)this.referencedModelPart).findSubPart(name, null), furtherPaths);
    }
}

