/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Set;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EqlQueryParser;
import org.springframework.data.jpa.repository.query.HqlQueryParser;
import org.springframework.data.jpa.repository.query.JpaQueryParserSupport;
import org.springframework.data.jpa.repository.query.JpqlQueryParser;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JpaQueryEnhancer
implements QueryEnhancer {
    private final DeclaredQuery query;
    private final JpaQueryParserSupport queryParser;

    private JpaQueryEnhancer(DeclaredQuery query, JpaQueryParserSupport queryParser) {
        this.query = query;
        this.queryParser = queryParser;
    }

    public static JpaQueryEnhancer forJpql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return new JpaQueryEnhancer(query, new JpqlQueryParser(query.getQueryString()));
    }

    public static JpaQueryEnhancer forHql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return new JpaQueryEnhancer(query, new HqlQueryParser(query.getQueryString()));
    }

    public static JpaQueryEnhancer forEql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return new JpaQueryEnhancer(query, new EqlQueryParser(query.getQueryString()));
    }

    protected JpaQueryParserSupport getQueryParsingStrategy() {
        return this.queryParser;
    }

    @Override
    public String applySorting(Sort sort) {
        return this.queryParser.renderSortedQuery(sort);
    }

    @Override
    public String applySorting(Sort sort, String alias) {
        return this.applySorting(sort);
    }

    @Override
    public String detectAlias() {
        return this.queryParser.findAlias();
    }

    @Override
    public String createCountQueryFor() {
        return this.createCountQueryFor(null);
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        return this.queryParser.createCountQuery(countProjection);
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.queryParser.hasConstructorExpression();
    }

    @Override
    public String getProjection() {
        return this.queryParser.projection();
    }

    @Override
    public Set<String> getJoinAliases() {
        return Set.of();
    }

    @Override
    public DeclaredQuery getQuery() {
        return this.query;
    }
}

