/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodClassKey;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public final class BridgeMethodResolver {
    private static final Map<Object, Method> cache = new ConcurrentReferenceHashMap<Object, Method>();

    private BridgeMethodResolver() {
    }

    public static Method findBridgedMethod(Method bridgeMethod) {
        return BridgeMethodResolver.resolveBridgeMethod(bridgeMethod, bridgeMethod.getDeclaringClass());
    }

    public static Method getMostSpecificMethod(Method bridgeMethod, @Nullable Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod(bridgeMethod, targetClass);
        return BridgeMethodResolver.resolveBridgeMethod(specificMethod, targetClass != null ? targetClass : specificMethod.getDeclaringClass());
    }

    private static Method resolveBridgeMethod(Method bridgeMethod, Class<?> targetClass) {
        boolean localBridge;
        boolean bl = localBridge = targetClass == bridgeMethod.getDeclaringClass();
        if (!bridgeMethod.isBridge() && localBridge) {
            return bridgeMethod;
        }
        Object cacheKey = localBridge ? bridgeMethod : new MethodClassKey(bridgeMethod, targetClass);
        Method bridgedMethod = cache.get(cacheKey);
        if (bridgedMethod == null) {
            ArrayList<Method> candidateMethods = new ArrayList<Method>();
            ReflectionUtils.MethodFilter filter = candidateMethod -> BridgeMethodResolver.isBridgedCandidateFor(candidateMethod, bridgeMethod);
            ReflectionUtils.doWithMethods(targetClass, candidateMethods::add, filter);
            if (!candidateMethods.isEmpty()) {
                Method method = bridgedMethod = candidateMethods.size() == 1 ? (Method)candidateMethods.get(0) : BridgeMethodResolver.searchCandidates(candidateMethods, bridgeMethod, targetClass);
            }
            if (bridgedMethod == null) {
                bridgedMethod = bridgeMethod;
            }
            cache.put(cacheKey, bridgedMethod);
        }
        return bridgedMethod;
    }

    private static boolean isBridgedCandidateFor(Method candidateMethod, Method bridgeMethod) {
        return !candidateMethod.isBridge() && candidateMethod.getName().equals(bridgeMethod.getName()) && candidateMethod.getParameterCount() == bridgeMethod.getParameterCount();
    }

    @Nullable
    private static Method searchCandidates(List<Method> candidateMethods, Method bridgeMethod, Class<?> targetClass) {
        if (candidateMethods.isEmpty()) {
            return null;
        }
        Method previousMethod = null;
        boolean sameSig = true;
        for (Method candidateMethod : candidateMethods) {
            if (BridgeMethodResolver.isBridgeMethodFor(bridgeMethod, candidateMethod, targetClass)) {
                return candidateMethod;
            }
            if (previousMethod != null) {
                sameSig = sameSig && Arrays.equals(candidateMethod.getGenericParameterTypes(), previousMethod.getGenericParameterTypes());
            }
            previousMethod = candidateMethod;
        }
        return sameSig ? candidateMethods.get(0) : null;
    }

    static boolean isBridgeMethodFor(Method bridgeMethod, Method candidateMethod, Class<?> targetClass) {
        if (BridgeMethodResolver.isResolvedTypeMatch(candidateMethod, bridgeMethod, targetClass)) {
            return true;
        }
        Method method = BridgeMethodResolver.findGenericDeclaration(bridgeMethod);
        return method != null && BridgeMethodResolver.isResolvedTypeMatch(method, candidateMethod, targetClass);
    }

    private static boolean isResolvedTypeMatch(Method genericMethod, Method candidateMethod, Class<?> targetClass) {
        Type[] genericParameters = genericMethod.getGenericParameterTypes();
        if (genericParameters.length != candidateMethod.getParameterCount()) {
            return false;
        }
        Class<?>[] candidateParameters = candidateMethod.getParameterTypes();
        for (int i = 0; i < candidateParameters.length; ++i) {
            ResolvableType genericParameter = ResolvableType.forMethodParameter(genericMethod, i, targetClass);
            Class<?> candidateParameter = candidateParameters[i];
            if (candidateParameter.isArray() && !candidateParameter.componentType().equals(genericParameter.getComponentType().toClass())) {
                return false;
            }
            if (ClassUtils.resolvePrimitiveIfNecessary(candidateParameter).equals(ClassUtils.resolvePrimitiveIfNecessary(genericParameter.toClass()))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Method findGenericDeclaration(Method bridgeMethod) {
        if (!bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        for (Class<?> superclass = bridgeMethod.getDeclaringClass().getSuperclass(); superclass != null && Object.class != superclass; superclass = superclass.getSuperclass()) {
            Method method = BridgeMethodResolver.searchForMatch(superclass, bridgeMethod);
            if (method == null || method.isBridge()) continue;
            return method;
        }
        Class<?>[] interfaces = ClassUtils.getAllInterfacesForClass(bridgeMethod.getDeclaringClass());
        return BridgeMethodResolver.searchInterfaces(interfaces, bridgeMethod);
    }

    @Nullable
    private static Method searchInterfaces(Class<?>[] interfaces, Method bridgeMethod) {
        for (Class<?> ifc : interfaces) {
            Method method = BridgeMethodResolver.searchForMatch(ifc, bridgeMethod);
            if (method != null && !method.isBridge()) {
                return method;
            }
            method = BridgeMethodResolver.searchInterfaces(ifc.getInterfaces(), bridgeMethod);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    @Nullable
    private static Method searchForMatch(Class<?> type, Method bridgeMethod) {
        try {
            return type.getDeclaredMethod(bridgeMethod.getName(), bridgeMethod.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean isVisibilityBridgeMethodPair(Method bridgeMethod, Method bridgedMethod) {
        if (bridgeMethod == bridgedMethod) {
            return true;
        }
        return bridgeMethod.getReturnType().equals(bridgedMethod.getReturnType()) && bridgeMethod.getParameterCount() == bridgedMethod.getParameterCount() && Arrays.equals(bridgeMethod.getParameterTypes(), bridgedMethod.getParameterTypes());
    }
}

