/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.AbstractUpdateOrDeleteStatement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;

public class UpdateStatement
extends AbstractUpdateOrDeleteStatement {
    private final List<Assignment> assignments;

    public UpdateStatement(NamedTableReference targetTable, List<Assignment> assignments, Predicate restriction) {
        this(null, targetTable, new FromClause(), assignments, restriction, Collections.emptyList());
    }

    public UpdateStatement(NamedTableReference targetTable, List<Assignment> assignments, Predicate restriction, List<ColumnReference> returningColumns) {
        this(null, targetTable, new FromClause(), assignments, restriction, returningColumns);
    }

    public UpdateStatement(NamedTableReference targetTable, FromClause fromClause, List<Assignment> assignments, Predicate restriction) {
        this(null, targetTable, fromClause, assignments, restriction, Collections.emptyList());
    }

    public UpdateStatement(NamedTableReference targetTable, FromClause fromClause, List<Assignment> assignments, Predicate restriction, List<ColumnReference> returningColumns) {
        this(null, targetTable, fromClause, assignments, restriction, returningColumns);
    }

    public UpdateStatement(CteContainer cteContainer, NamedTableReference targetTable, FromClause fromClause, List<Assignment> assignments, Predicate restriction, List<ColumnReference> returningColumns) {
        super(cteContainer, targetTable, fromClause, restriction, returningColumns);
        this.assignments = assignments;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitUpdateStatement(this);
    }

    public static class UpdateStatementBuilder {
        private final NamedTableReference targetTableRef;
        private List<Assignment> assignments;
        private Predicate restriction;

        public UpdateStatementBuilder(NamedTableReference targetTableRef) {
            this.targetTableRef = targetTableRef;
        }

        public UpdateStatementBuilder addAssignment(Assignment assignment) {
            if (this.assignments == null) {
                this.assignments = new ArrayList<Assignment>();
            }
            this.assignments.add(assignment);
            return this;
        }

        public UpdateStatementBuilder addRestriction(Predicate restriction) {
            this.restriction = SqlAstTreeHelper.combinePredicates(this.restriction, restriction);
            return this;
        }

        public UpdateStatementBuilder setRestriction(Predicate restriction) {
            this.restriction = restriction;
            return this;
        }

        public UpdateStatement createUpdateAst() {
            if (this.assignments == null || this.assignments.isEmpty()) {
                return null;
            }
            return new UpdateStatement(this.targetTableRef, new FromClause(), this.assignments, this.restriction);
        }
    }
}

