/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import java.lang.reflect.Array;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public class ArrayConverter<T, S, E, F>
implements BasicValueConverter<T, S> {
    private final BasicValueConverter<E, F> elementConverter;
    private final JavaType<T> domainJavaType;
    private final JavaType<S> relationalJavaType;

    public ArrayConverter(BasicValueConverter<E, F> elementConverter, JavaType<T> domainJavaType, JavaType<S> relationalJavaType) {
        this.elementConverter = elementConverter;
        this.domainJavaType = domainJavaType;
        this.relationalJavaType = relationalJavaType;
    }

    @Override
    public T toDomainValue(S relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        Class<E> elementClass = this.elementConverter.getDomainJavaType().getJavaTypeClass();
        if (relationalForm.getClass().getComponentType() == elementClass) {
            return (T)relationalForm;
        }
        return this.convertTo((Object[])relationalForm, elementClass);
    }

    private T convertTo(F[] relationalArray, Class<E> elementClass) {
        Object[] domainArray = (Object[])Array.newInstance(elementClass, relationalArray.length);
        for (int i = 0; i < relationalArray.length; ++i) {
            domainArray[i] = this.elementConverter.toDomainValue(relationalArray[i]);
        }
        return (T)domainArray;
    }

    @Override
    public S toRelationalValue(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        Class<F> elementClass = this.elementConverter.getRelationalJavaType().getJavaTypeClass();
        if (domainForm.getClass().getComponentType() == elementClass) {
            return (S)domainForm;
        }
        return this.convertFrom((Object[])domainForm, elementClass);
    }

    private S convertFrom(E[] domainArray, Class<F> elementClass) {
        Object[] relationalArray = (Object[])Array.newInstance(elementClass, domainArray.length);
        for (int i = 0; i < domainArray.length; ++i) {
            relationalArray[i] = this.elementConverter.toRelationalValue(domainArray[i]);
        }
        return (S)relationalArray;
    }

    @Override
    public JavaType<T> getDomainJavaType() {
        return this.domainJavaType;
    }

    @Override
    public JavaType<S> getRelationalJavaType() {
        return this.relationalJavaType;
    }
}

