/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.net.URI;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

public class AwsIamAuthenticationOptions {
    public static final String DEFAULT_AWS_AUTHENTICATION_PATH = "aws";
    private final String path;
    private final AwsCredentialsProvider credentialsProvider;
    private final AwsRegionProvider regionProvider;
    @Nullable
    private final String role;
    @Nullable
    private final String serverId;
    private final URI endpointUri;

    private AwsIamAuthenticationOptions(String path, AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, @Nullable String role, @Nullable String serverId, URI endpointUri) {
        this.path = path;
        this.credentialsProvider = credentialsProvider;
        this.regionProvider = regionProvider;
        this.role = role;
        this.serverId = serverId;
        this.endpointUri = endpointUri;
    }

    public static AwsIamAuthenticationOptionsBuilder builder() {
        return new AwsIamAuthenticationOptionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public AwsRegionProvider getRegionProvider() {
        return this.regionProvider;
    }

    @Nullable
    public String getRole() {
        return this.role;
    }

    @Nullable
    public String getServerId() {
        return this.serverId;
    }

    public URI getEndpointUri() {
        return this.endpointUri;
    }

    public static class AwsIamAuthenticationOptionsBuilder {
        private String path = "aws";
        @Nullable
        private AwsCredentialsProvider credentialsProvider;
        private AwsRegionProvider regionProvider = DefaultAwsRegionProviderChain.builder().build();
        @Nullable
        private String role;
        @Nullable
        private String serverId;
        private URI endpointUri = URI.create("https://sts.amazonaws.com/");

        AwsIamAuthenticationOptionsBuilder() {
        }

        public AwsIamAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder credentials(AwsCredentials credentials) {
            Assert.notNull((Object)credentials, (String)"Credentials must not be null");
            return this.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials));
        }

        public AwsIamAuthenticationOptionsBuilder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            Assert.notNull((Object)credentialsProvider, (String)"AwsCredentialsProvider must not be null");
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder region(Region region) {
            Assert.notNull((Object)region, (String)"Region must not be null");
            return this.regionProvider(() -> region);
        }

        public AwsIamAuthenticationOptionsBuilder regionProvider(AwsRegionProvider regionProvider) {
            Assert.notNull((Object)regionProvider, (String)"AwsRegionProvider must not be null");
            this.regionProvider = regionProvider;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder role(String role) {
            Assert.hasText((String)role, (String)"Role must not be null or empty");
            this.role = role;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder serverId(String serverId) {
            Assert.hasText((String)serverId, (String)"Server name must not be null or empty");
            this.serverId = serverId;
            return this;
        }

        public AwsIamAuthenticationOptionsBuilder serverName(String serverName) {
            return this.serverId(serverName);
        }

        public AwsIamAuthenticationOptionsBuilder endpointUri(URI endpointUri) {
            Assert.notNull((Object)endpointUri, (String)"Endpoint URI must not be null");
            this.endpointUri = endpointUri;
            return this;
        }

        public AwsIamAuthenticationOptions build() {
            Assert.state((this.credentialsProvider != null ? 1 : 0) != 0, (String)"Credentials or CredentialProvider must not be null");
            return new AwsIamAuthenticationOptions(this.path, this.credentialsProvider, this.regionProvider, this.role, this.serverId, this.endpointUri);
        }
    }
}

