/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.springframework.data.jpa.domain.SpecificationComposition;
import org.springframework.lang.Nullable;

public interface Specification<T>
extends Serializable {
    public static final long serialVersionUID = 1L;

    public static <T> Specification<T> not(@Nullable Specification<T> spec) {
        return spec == null ? (root, query, builder) -> null : (root, query, builder) -> builder.not((Expression)spec.toPredicate(root, query, builder));
    }

    public static <T> Specification<T> where(@Nullable Specification<T> spec) {
        return spec == null ? (root, query, builder) -> null : spec;
    }

    default public Specification<T> and(@Nullable Specification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    default public Specification<T> or(@Nullable Specification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @Nullable
    public Predicate toPredicate(Root<T> var1, CriteriaQuery<?> var2, CriteriaBuilder var3);

    public static <T> Specification<T> allOf(Iterable<Specification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(Specification.where(null), Specification::and);
    }

    @SafeVarargs
    public static <T> Specification<T> allOf(Specification<T> ... specifications) {
        return Specification.allOf(Arrays.asList(specifications));
    }

    public static <T> Specification<T> anyOf(Iterable<Specification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(Specification.where(null), Specification::or);
    }

    @SafeVarargs
    public static <T> Specification<T> anyOf(Specification<T> ... specifications) {
        return Specification.anyOf(Arrays.asList(specifications));
    }
}

