/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Optional;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jws.crypto.HashUtils;

public class SdJwtUtils {
    public static final ObjectMapper mapper = new ObjectMapper();
    private static SecureRandom RANDOM = new SecureRandom();
    static ArraySpacedPrettyPrinter arraySpacedPrettyPrinter = new ArraySpacedPrettyPrinter();
    public static boolean arrayEltSpaced = true;

    public static String encodeNoPad(byte[] bytes) {
        return Base64Url.encode((byte[])bytes);
    }

    public static String hashAndBase64EncodeNoPad(byte[] disclosureBytes, String hashAlg) {
        return SdJwtUtils.encodeNoPad(HashUtils.hash(hashAlg, disclosureBytes));
    }

    public static String requireNonEmpty(String str, String message) {
        return Optional.ofNullable(str).filter(s -> !s.isEmpty()).orElseThrow(() -> new IllegalArgumentException(message));
    }

    public static String randomSalt() {
        return SdJwtUtils.encodeNoPad(SdJwtUtils.randomBytes(16));
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String printJsonArray(Object[] array) throws JsonProcessingException {
        if (arrayEltSpaced) {
            return SdJwtUtils.arraySpacedPrettyPrinter.writer.writeValueAsString((Object)array);
        }
        return mapper.writeValueAsString((Object)array);
    }

    static class ArraySpacedPrettyPrinter
    extends MinimalPrettyPrinter {
        final ObjectMapper prettyPrinObjectMapper = new ObjectMapper();
        final ObjectWriter writer;

        public ArraySpacedPrettyPrinter() {
            this.prettyPrinObjectMapper.setDefaultPrettyPrinter((PrettyPrinter)this);
            this.writer = this.prettyPrinObjectMapper.writer((PrettyPrinter)this);
        }

        public void writeArrayValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(',');
            jg.writeRaw(' ');
        }

        public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(',');
            jg.writeRaw(' ');
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(':');
            jg.writeRaw(' ');
        }
    }
}

