// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeApisixConsumers implements ApisixConsumerInterface
type FakeApisixConsumers struct {
	Fake *FakeApisixV2
	ns   string
}

var apisixconsumersResource = v2.SchemeGroupVersion.WithResource("apisixconsumers")

var apisixconsumersKind = v2.SchemeGroupVersion.WithKind("ApisixConsumer")

// Get takes name of the apisixConsumer, and returns the corresponding apisixConsumer object, and an error if there is any.
func (c *FakeApisixConsumers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.ApisixConsumer, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(apisixconsumersResource, c.ns, name), &v2.ApisixConsumer{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixConsumer), err
}

// List takes label and field selectors, and returns the list of ApisixConsumers that match those selectors.
func (c *FakeApisixConsumers) List(ctx context.Context, opts v1.ListOptions) (result *v2.ApisixConsumerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(apisixconsumersResource, apisixconsumersKind, c.ns, opts), &v2.ApisixConsumerList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2.ApisixConsumerList{ListMeta: obj.(*v2.ApisixConsumerList).ListMeta}
	for _, item := range obj.(*v2.ApisixConsumerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested apisixConsumers.
func (c *FakeApisixConsumers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(apisixconsumersResource, c.ns, opts))

}

// Create takes the representation of a apisixConsumer and creates it.  Returns the server's representation of the apisixConsumer, and an error, if there is any.
func (c *FakeApisixConsumers) Create(ctx context.Context, apisixConsumer *v2.ApisixConsumer, opts v1.CreateOptions) (result *v2.ApisixConsumer, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(apisixconsumersResource, c.ns, apisixConsumer), &v2.ApisixConsumer{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixConsumer), err
}

// Update takes the representation of a apisixConsumer and updates it. Returns the server's representation of the apisixConsumer, and an error, if there is any.
func (c *FakeApisixConsumers) Update(ctx context.Context, apisixConsumer *v2.ApisixConsumer, opts v1.UpdateOptions) (result *v2.ApisixConsumer, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(apisixconsumersResource, c.ns, apisixConsumer), &v2.ApisixConsumer{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixConsumer), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeApisixConsumers) UpdateStatus(ctx context.Context, apisixConsumer *v2.ApisixConsumer, opts v1.UpdateOptions) (*v2.ApisixConsumer, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(apisixconsumersResource, "status", c.ns, apisixConsumer), &v2.ApisixConsumer{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixConsumer), err
}

// Delete takes name of the apisixConsumer and deletes it. Returns an error if one occurs.
func (c *FakeApisixConsumers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(apisixconsumersResource, c.ns, name, opts), &v2.ApisixConsumer{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeApisixConsumers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(apisixconsumersResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v2.ApisixConsumerList{})
	return err
}

// Patch applies the patch and returns the patched apisixConsumer.
func (c *FakeApisixConsumers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.ApisixConsumer, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(apisixconsumersResource, c.ns, name, pt, data, subresources...), &v2.ApisixConsumer{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixConsumer), err
}
