/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

/** A {@link SchemaHelpers} for the Spark Batch Runner. */
public class SchemaHelpers {
  private static final StructType BINARY_SCHEMA =
      new StructType(
          new StructField[] {
            StructField.apply("binaryStructField", DataTypes.BinaryType, true, Metadata.empty())
          });

  public static StructType binarySchema() {
    // we use a binary schema for now because:
    // using a empty schema raises a indexOutOfBoundsException
    // using a NullType schema stores null in the elements
    return BINARY_SCHEMA;
  }
}
