/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.watch.IDeadWatcherListener;
import org.apache.zookeeper.server.watch.WatcherCleaner;
import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherCleanerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(WatcherCleanerTest.class);

    @Test
    public void testProcessDeadWatchersBasedOnThreshold() {
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        int threshold = 3;
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, threshold, 60, 1, 10);
        cleaner.start();
        int i = 0;
        while (i++ < threshold - 1) {
            cleaner.addDeadWatcher(i);
        }
        Assert.assertEquals((long)0L, (long)listener.getDeadWatchers().size());
        listener.setCountDownLatch(new CountDownLatch(1));
        cleaner.addDeadWatcher(i);
        Assert.assertTrue((boolean)listener.wait(1000));
        Assert.assertEquals((long)threshold, (long)listener.getDeadWatchers().size());
    }

    @Test
    public void testProcessDeadWatchersBasedOnTime() {
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, 10, 1, 1, 10);
        cleaner.start();
        cleaner.addDeadWatcher(1);
        Assert.assertEquals((long)0L, (long)listener.getDeadWatchers().size());
        listener.setCountDownLatch(new CountDownLatch(1));
        Assert.assertTrue((boolean)listener.wait(2000));
        Assert.assertEquals((long)1L, (long)listener.getDeadWatchers().size());
        listener.setCountDownLatch(new CountDownLatch(1));
        Assert.assertFalse((boolean)listener.wait(2000));
    }

    @Test
    public void testMaxInProcessingDeadWatchers() {
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        int delayMs = 1000;
        listener.setDelayMs(delayMs);
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, 1, 60, 1, 1);
        cleaner.start();
        listener.setCountDownLatch(new CountDownLatch(2));
        long startTime = Time.currentElapsedTime();
        cleaner.addDeadWatcher(1);
        cleaner.addDeadWatcher(2);
        long time = Time.currentElapsedTime() - startTime;
        System.out.println("time used " + time);
        Assert.assertTrue((Time.currentElapsedTime() - startTime >= (long)delayMs ? 1 : 0) != 0);
        Assert.assertTrue((boolean)listener.wait(5000));
    }

    @Test
    public void testDeadWatcherMetrics() {
        ServerMetrics.getMetrics().resetAll();
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, 1, 1, 1, 1);
        listener.setDelayMs(20);
        cleaner.start();
        listener.setCountDownLatch(new CountDownLatch(3));
        cleaner.addDeadWatcher(1);
        cleaner.addDeadWatcher(2);
        cleaner.addDeadWatcher(3);
        Assert.assertTrue((boolean)listener.wait(5000));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertThat((String)"Adding dead watcher should be stalled twice", (Object)((Long)values.get("add_dead_watcher_stall_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((String)"Total dead watchers added to the queue should be 3", (Object)3L, (Object)values.get("dead_watchers_queued"));
        Assert.assertEquals((String)"Total dead watchers cleared should be 3", (Object)3L, (Object)values.get("dead_watchers_cleared"));
        Assert.assertEquals((Object)3L, (Object)values.get("cnt_dead_watchers_cleaner_latency"));
        Assert.assertEquals((double)20.0, (double)((Double)values.get("avg_dead_watchers_cleaner_latency")), (double)5.0);
        Assert.assertEquals((double)20.0, (double)((Long)values.get("min_dead_watchers_cleaner_latency")).doubleValue(), (double)5.0);
        Assert.assertEquals((double)20.0, (double)((Long)values.get("max_dead_watchers_cleaner_latency")).doubleValue(), (double)5.0);
        Assert.assertEquals((double)20.0, (double)((Long)values.get("p50_dead_watchers_cleaner_latency")).doubleValue(), (double)5.0);
        Assert.assertEquals((double)20.0, (double)((Long)values.get("p95_dead_watchers_cleaner_latency")).doubleValue(), (double)5.0);
        Assert.assertEquals((double)20.0, (double)((Long)values.get("p99_dead_watchers_cleaner_latency")).doubleValue(), (double)5.0);
    }

    public static class MyDeadWatcherListener
    implements IDeadWatcherListener {
        private CountDownLatch latch;
        private int delayMs;
        private Set<Integer> deadWatchers = new HashSet<Integer>();

        public void setCountDownLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public void setDelayMs(int delayMs) {
            this.delayMs = delayMs;
        }

        public void processDeadWatchers(Set<Integer> deadWatchers) {
            if (this.delayMs > 0) {
                try {
                    Thread.sleep(this.delayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.deadWatchers.clear();
            this.deadWatchers.addAll(deadWatchers);
            this.latch.countDown();
        }

        public Set<Integer> getDeadWatchers() {
            return this.deadWatchers;
        }

        public boolean wait(int maxWaitMs) {
            try {
                return this.latch.await(maxWaitMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }
}

