/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metastore;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.UnsignedBytes;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.metastore.MetastoreTable;

public class Value {
    private static final Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();
    protected Map<String, byte[]> fields;

    public Value() {
        this.fields = new HashMap<String, byte[]>();
    }

    public Value(Value v) {
        this.fields = new HashMap<String, byte[]>(v.fields);
    }

    public byte[] getField(String field) {
        return this.fields.get(field);
    }

    public Value setField(String field, byte[] data) {
        this.fields.put(field, data);
        return this;
    }

    public Value clearFields() {
        this.fields.clear();
        return this;
    }

    public Set<String> getFields() {
        return this.fields.keySet();
    }

    public Map<String, byte[]> getFieldsMap() {
        return Collections.unmodifiableMap(this.fields);
    }

    public Value project(Set<String> fields) {
        if (MetastoreTable.ALL_FIELDS == fields) {
            return new Value(this);
        }
        Value v = new Value();
        for (String f : fields) {
            byte[] data = this.fields.get(f);
            v.setField(f, data);
        }
        return v;
    }

    public int hashCode() {
        HashFunction hf = Hashing.murmur3_32();
        Hasher hc = hf.newHasher();
        for (String key : this.fields.keySet()) {
            hc.putString((CharSequence)key, Charset.defaultCharset());
        }
        return hc.hash().asInt();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        if (this.fields.size() != other.fields.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> entry : this.fields.entrySet()) {
            byte[] v2;
            String f = entry.getKey();
            byte[] v1 = entry.getValue();
            if (0 == comparator.compare(v1, v2 = other.fields.get(f))) continue;
            return false;
        }
        return true;
    }

    public Value merge(Value other) {
        for (Map.Entry<String, byte[]> entry : other.fields.entrySet()) {
            if (null == entry.getValue()) {
                this.fields.remove(entry.getKey());
                continue;
            }
            this.fields.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<String, byte[]> entry : this.fields.entrySet()) {
            String f = entry.getKey();
            if (null == f) {
                f = "NULL";
            }
            String value = null == entry.getValue() ? "NONE" : new String(entry.getValue(), StandardCharsets.UTF_8);
            sb.append("('").append(f).append("'=").append(value).append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

