/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.table;

import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.exceptions.StreamExistsException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.AdminCommand;
import org.apache.bookkeeper.stream.proto.StorageType;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class CreateTableCommand
extends AdminCommand<Flags> {
    private static final String NAME = "create";
    private static final String DESC = "Create a table";

    public CreateTableCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<table-name>").build());
    }

    @Override
    protected void run(StorageAdminClient admin, BKFlags globalFlags, Flags flags) throws Exception {
        Preconditions.checkArgument((!flags.arguments.isEmpty() ? 1 : 0) != 0, (Object)"Table name is not provided");
        Preconditions.checkArgument((flags.numRanges >= 1 ? 1 : 0) != 0, (Object)("Invalid number of ranges specified for creating table : " + flags.numRanges));
        String streamName = (String)flags.arguments.get(0);
        try {
            StreamConfiguration conf = StreamConfiguration.newBuilder((StreamConfiguration)ProtocolConstants.DEFAULT_STREAM_CONF).setMinNumRanges(flags.numRanges).setInitialNumRanges(flags.numRanges).build();
            StreamProperties nsProps = (StreamProperties)FutureUtils.result((CompletableFuture)admin.createStream(globalFlags.namespace, streamName, StreamConfiguration.newBuilder((StreamConfiguration)conf).setStorageType(StorageType.TABLE).build()));
            this.spec.console().println("Successfully created table '" + streamName + "':");
            this.spec.console().println(nsProps);
        }
        catch (NamespaceNotFoundException nfe) {
            this.spec.console().println("Namespace '" + globalFlags.namespace + "' does not exist");
        }
        catch (StreamExistsException see) {
            this.spec.console().println("Table '" + globalFlags.namespace + "' already exists");
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-r", "--num-ranges"}, description="num of ranges for the table")
        private int numRanges = 3;
    }
}

