/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpHandlers;
import io.vertx.core.http.impl.HttpServerRequestImpl;
import io.vertx.core.http.impl.HttpServerResponseImpl;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.spi.metrics.HttpServerMetrics;

public class WebSocketRequestHandler
implements Handler<HttpServerRequest> {
    private final HttpServerMetrics metrics;
    private final HttpHandlers handlers;

    WebSocketRequestHandler(HttpServerMetrics metrics, HttpHandlers handlers) {
        this.metrics = metrics;
        this.handlers = handlers;
    }

    @Override
    public void handle(HttpServerRequest req) {
        if (req.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) || this.handlers.requestHandler == null) {
            this.handle((HttpServerRequestImpl)req);
        } else {
            this.handlers.requestHandler.handle(req);
        }
    }

    @Override
    private void handle(HttpServerRequestImpl req) {
        Buffer body = Buffer.buffer();
        boolean[] failed = new boolean[1];
        req.handler(buff -> {
            if (!failed[0]) {
                body.appendBuffer((Buffer)buff);
                if (body.length() > 8192) {
                    failed[0] = true;
                    HttpServerResponseImpl resp = req.response();
                    resp.setStatusCode(413).end();
                    resp.close();
                }
            }
        });
        req.endHandler(v -> {
            if (!failed[0]) {
                this.handle(req, body);
            }
        });
    }

    private void handle(HttpServerRequestImpl req, Buffer body) {
        HttpRequest nettyReq = req.nettyRequest();
        nettyReq = new DefaultFullHttpRequest(nettyReq.protocolVersion(), nettyReq.method(), nettyReq.uri(), body.getByteBuf(), nettyReq.headers(), (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
        req.setRequest(nettyReq);
        if (this.handlers.wsHandler != null) {
            ServerWebSocketImpl ws = ((Http1xServerConnection)req.connection()).createWebSocket(req);
            if (ws == null) {
                return;
            }
            this.handlers.wsHandler.handle(ws);
            ws.tryHandshake(101);
        } else {
            this.handlers.requestHandler.handle(req);
        }
    }
}

