/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Excerpts;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public enum BuilderFactory {
    NO_ARGS_CONSTRUCTOR{

        @Override
        public Excerpt newBuilder(Type builderType, TypeInference typeInference) {
            if (typeInference == TypeInference.INFERRED_TYPES) {
                return Excerpts.add("%s()", builderType.constructor());
            }
            return Excerpts.add("new %s()", builderType);
        }
    }
    ,
    BUILDER_METHOD{

        @Override
        public Excerpt newBuilder(Type builderType, TypeInference typeInference) {
            if (typeInference == TypeInference.INFERRED_TYPES) {
                return Excerpts.add("%s.builder()", builderType.getQualifiedName().enclosingType());
            }
            return Excerpts.add("%s.%sbuilder()", builderType.getQualifiedName().enclosingType(), builderType.typeParameters());
        }
    }
    ,
    NEW_BUILDER_METHOD{

        @Override
        public Excerpt newBuilder(Type builderType, TypeInference typeInference) {
            if (typeInference == TypeInference.INFERRED_TYPES) {
                return Excerpts.add("%s.newBuilder()", builderType.getQualifiedName().enclosingType());
            }
            return Excerpts.add("%s.%snewBuilder()", builderType.getQualifiedName().enclosingType(), builderType.typeParameters());
        }
    };


    public static Optional<BuilderFactory> from(TypeElement builderType) {
        ImmutableSet<String> staticMethods = BuilderFactory.findPotentialStaticFactoryMethods(builderType);
        if (BuilderFactory.typeIsAbstract(builderType)) {
            return Optional.empty();
        }
        if (staticMethods.contains("builder")) {
            return Optional.of(BUILDER_METHOD);
        }
        if (staticMethods.contains("newBuilder")) {
            return Optional.of(NEW_BUILDER_METHOD);
        }
        if (BuilderFactory.hasNoArgsConstructor(builderType)) {
            return Optional.of(NO_ARGS_CONSTRUCTOR);
        }
        return Optional.empty();
    }

    public abstract Excerpt newBuilder(Type var1, TypeInference var2);

    private static boolean typeIsAbstract(TypeElement type) {
        return type.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    static boolean hasNoArgsConstructor(TypeElement type) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(type.getEnclosedElements())) {
            if (!constructor.getParameters().isEmpty() || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableSet<String> findPotentialStaticFactoryMethods(TypeElement builderType) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        Element valueType = builderType.getEnclosingElement();
        for (ExecutableElement method : ElementFilter.methodsIn(valueType.getEnclosedElements())) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !method.getParameters().isEmpty() || !builderType.asType().toString().equals(method.getReturnType().toString())) continue;
            resultBuilder.add(method.getSimpleName().toString());
        }
        return resultBuilder.build();
    }

    public static enum TypeInference {
        EXPLICIT_TYPES,
        INFERRED_TYPES;

    }
}

