/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentRecursiveWatcherTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentRecursiveWatcherTest.class);
    private BlockingQueue<WatchedEvent> events;
    private Watcher persistentWatcher;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.events = new LinkedBlockingQueue<WatchedEvent>();
        this.persistentWatcher = event -> this.events.add(event);
    }

    @Test
    public void testBasic() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT_RECURSIVE);
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    @Test
    public void testBasicAsync() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            CountDownLatch latch = new CountDownLatch(1);
            AsyncCallback.VoidCallback cb = (rc, path, ctx) -> {
                if (rc == KeeperException.Code.OK.intValue()) {
                    latch.countDown();
                }
            };
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT_RECURSIVE, cb, null);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    private void internalTestBasic(ZooKeeper zk) throws KeeperException, InterruptedException {
        zk.create("/a", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = new Stat();
        zk.create("/a/b", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b", stat);
        zk.create("/a/b/c", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b/c", stat);
        zk.create("/a/b/c/d", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b/c/d", stat);
        zk.create("/a/b/c/d/e", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b/c/d/e", stat);
        stat = zk.setData("/a/b/c/d/e", new byte[0], -1);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b/c/d/e", stat);
        zk.delete("/a/b/c/d/e", -1);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeDeleted, "/a/b/c/d/e", zk.exists("/a/b/c/d", false).getPzxid());
        zk.create("/a/b/c/d/e", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b/c/d/e", stat);
    }

    @Test
    public void testRemoval() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT_RECURSIVE);
            zk.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Stat stat = new Stat();
            zk.create("/a/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b", stat);
            zk.create("/a/b/c", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b/c", stat);
            zk.removeWatches("/a/b", this.persistentWatcher, Watcher.WatcherType.Any, false);
            zk.create("/a/b/c/d", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.assertEvent(this.events, Watcher.Event.EventType.PersistentWatchRemoved, "/a/b", -1L);
        }
    }

    @Test
    public void testNoChildEvents() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.addWatch("/", this.persistentWatcher, AddWatchMode.PERSISTENT_RECURSIVE);
            LinkedBlockingQueue<WatchedEvent> childEvents = new LinkedBlockingQueue<WatchedEvent>();
            zk.getChildren("/a", childEvents::add);
            Stat createABStat = new Stat();
            zk.create("/a/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, createABStat);
            Stat createABCStat = new Stat();
            zk.create("/a/b/c", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, createABCStat);
            this.assertEvent(childEvents, Watcher.Event.EventType.NodeChildrenChanged, "/a", createABStat.getPzxid());
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b", createABStat);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b/c", createABCStat);
            Assertions.assertTrue((boolean)this.events.isEmpty());
        }
    }

    @Test
    public void testDisconnect() throws Exception {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT_RECURSIVE);
            this.stopServer();
            this.assertEvent(this.events, Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null, -1L);
            this.startServer();
            this.assertEvent(this.events, Watcher.Event.EventType.None, Watcher.Event.KeeperState.SyncConnected, null, -1L);
            this.internalTestBasic((ZooKeeper)zk);
        }
    }

    @Test
    public void testMultiClient() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk1 = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);
             TestableZooKeeper zk2 = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk1.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk1.create("/a/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk1.create("/a/b/c", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk1.addWatch("/a/b", this.persistentWatcher, AddWatchMode.PERSISTENT_RECURSIVE);
            Stat stat = zk1.setData("/a/b/c", "one".getBytes(), -1);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b/c", stat.getMzxid());
            stat = zk2.setData("/a/b/c", "two".getBytes(), -1);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b/c", stat.getMzxid());
            stat = zk2.setData("/a/b/c", "three".getBytes(), -1);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b/c", stat.getMzxid());
            stat = zk2.setData("/a/b/c", "four".getBytes(), -1);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeDataChanged, "/a/b/c", stat.getMzxid());
        }
    }

    @Test
    public void testSamePathWithDifferentWatchModes() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            LinkedBlockingQueue<WatchedEvent> dataEvents = new LinkedBlockingQueue<WatchedEvent>();
            LinkedBlockingQueue<WatchedEvent> childEvents = new LinkedBlockingQueue<WatchedEvent>();
            LinkedBlockingQueue<WatchedEvent> persistentEvents = new LinkedBlockingQueue<WatchedEvent>();
            LinkedBlockingQueue<WatchedEvent> recursiveEvents = new LinkedBlockingQueue<WatchedEvent>();
            zk.addWatch("/a", persistentEvents::add, AddWatchMode.PERSISTENT);
            zk.addWatch("/a", recursiveEvents::add, AddWatchMode.PERSISTENT_RECURSIVE);
            zk.exists("/a", dataEvents::add);
            Stat stat = new Stat();
            zk.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(dataEvents, Watcher.Event.EventType.NodeCreated, "/a", stat);
            this.assertEvent(persistentEvents, Watcher.Event.EventType.NodeCreated, "/a", stat);
            this.assertEvent(recursiveEvents, Watcher.Event.EventType.NodeCreated, "/a", stat);
            zk.getData("/a", dataEvents::add, null);
            stat = zk.setData("/a", new byte[0], -1);
            this.assertEvent(dataEvents, Watcher.Event.EventType.NodeDataChanged, "/a", stat);
            this.assertEvent(persistentEvents, Watcher.Event.EventType.NodeDataChanged, "/a", stat);
            this.assertEvent(recursiveEvents, Watcher.Event.EventType.NodeDataChanged, "/a", stat);
            zk.getChildren("/a", childEvents::add);
            zk.create("/a/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(childEvents, Watcher.Event.EventType.NodeChildrenChanged, "/a", stat);
            this.assertEvent(persistentEvents, Watcher.Event.EventType.NodeChildrenChanged, "/a", stat);
            this.assertEvent(recursiveEvents, Watcher.Event.EventType.NodeCreated, "/a/b", stat);
            zk.getChildren("/a", childEvents::add);
            zk.delete("/a/b", -1);
            stat = zk.exists("/a", false);
            this.assertEvent(childEvents, Watcher.Event.EventType.NodeChildrenChanged, "/a", stat.getPzxid());
            this.assertEvent(persistentEvents, Watcher.Event.EventType.NodeChildrenChanged, "/a", stat.getPzxid());
            this.assertEvent(recursiveEvents, Watcher.Event.EventType.NodeDeleted, "/a/b", stat.getPzxid());
            zk.getChildren("/a", childEvents::add);
            zk.getData("/a", dataEvents::add, null);
            zk.exists("/a", dataEvents::add);
            zk.delete("/a", -1);
            stat = zk.exists("/", false);
            this.assertEvent(childEvents, Watcher.Event.EventType.NodeDeleted, "/a", stat.getPzxid());
            this.assertEvent(dataEvents, Watcher.Event.EventType.NodeDeleted, "/a", stat.getPzxid());
            this.assertEvent(dataEvents, Watcher.Event.EventType.NodeDeleted, "/a", stat.getPzxid());
            this.assertEvent(persistentEvents, Watcher.Event.EventType.NodeDeleted, "/a", stat.getPzxid());
            this.assertEvent(recursiveEvents, Watcher.Event.EventType.NodeDeleted, "/a", stat.getPzxid());
        }
    }

    @Test
    public void testRootWatcher() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            zk.addWatch("/", this.persistentWatcher, AddWatchMode.PERSISTENT_RECURSIVE);
            Stat stat = new Stat();
            zk.create("/a", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a", stat.getMzxid());
            zk.create("/a/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/a/b", stat.getMzxid());
            zk.create("/b", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/b", stat.getMzxid());
            zk.create("/b/c", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
            this.assertEvent(this.events, Watcher.Event.EventType.NodeCreated, "/b/c", stat.getMzxid());
        }
    }

    private void assertEvent(BlockingQueue<WatchedEvent> events, Watcher.Event.EventType eventType, String path, Stat stat) throws InterruptedException {
        this.assertEvent(events, eventType, path, stat.getMzxid());
    }

    private void assertEvent(BlockingQueue<WatchedEvent> events, Watcher.Event.EventType eventType, String path, long zxid) throws InterruptedException {
        this.assertEvent(events, eventType, Watcher.Event.KeeperState.SyncConnected, path, zxid);
    }

    private void assertEvent(BlockingQueue<WatchedEvent> events, Watcher.Event.EventType eventType, Watcher.Event.KeeperState keeperState, String path, long zxid) throws InterruptedException {
        WatchedEvent actualEvent = events.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)actualEvent);
        WatchedEvent expectedEvent = new WatchedEvent(eventType, keeperState, path, zxid);
        TestUtils.assertWatchedEventEquals(expectedEvent, actualEvent);
    }
}

