/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.BaseSpscLinkedArrayQueue;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscGrowableArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    public SpscGrowableArrayQueue(int capacity) {
        this(Pow2.roundToPowerOfTwo(Math.max(capacity, 32) / 2), Math.max(capacity, 32));
    }

    public SpscGrowableArrayQueue(int initialCapacity, int capacity) {
        int p2initialCapacity = Pow2.roundToPowerOfTwo(Math.max(initialCapacity, 32) / 2);
        int p2capacity = Pow2.roundToPowerOfTwo(Math.max(capacity, 32));
        if (p2initialCapacity >= p2capacity) {
            throw new IllegalArgumentException("Initial capacity(" + initialCapacity + ") rounded up to a power of 2 cannot exceed maximum capacity (" + capacity + ")rounded up to a power of 2");
        }
        long mask = p2initialCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(p2initialCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2initialCapacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.maxQueueCapacity = p2capacity;
        this.producerLimit = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    protected boolean offerColdPath(E[] buffer, long mask, E e, long index, long offset) {
        int maxCapacity;
        int lookAheadStep = this.producerLookAheadStep;
        if (lookAheadStep > 0) {
            long lookAheadElementOffset = CircularArrayOffsetCalculator.calcElementOffset(index + (long)lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                this.producerLimit = index + (long)lookAheadStep - 1L;
                this.writeToQueue(buffer, e, index, offset);
                return true;
            }
            int maxCapacity2 = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity2) {
                if (null == UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                    this.writeToQueue(buffer, e, index, offset);
                    return true;
                }
                return false;
            }
            if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(index + 1L, mask))) {
                this.writeToQueue(buffer, e, index, offset);
            } else {
                int newCapacity = (int)(2L * (mask + 1L));
                E[] newBuffer = CircularArrayOffsetCalculator.allocate(newCapacity + 1);
                this.producerBuffer = newBuffer;
                this.producerMask = newCapacity - 1;
                if (newCapacity == maxCapacity2) {
                    long currConsumerIndex = this.lvConsumerIndex();
                    this.producerLookAheadStep = -((int)(index - currConsumerIndex));
                    this.producerLimit = currConsumerIndex + (long)maxCapacity2 - 1L;
                } else {
                    this.producerLimit = index + this.producerMask - 1L;
                    this.adjustLookAheadStep(newCapacity);
                }
                long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index, this.producerMask);
                UnsafeRefArrayAccess.soElement(newBuffer, offsetInNew, e);
                this.soNext(buffer, newBuffer);
                UnsafeRefArrayAccess.soElement(buffer, offset, JUMP);
                this.soProducerIndex(index + 1L);
            }
            return true;
        }
        int prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerLimit - (long)maxCapacity + (long)prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.producerLookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerLimit = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, e, index, offset);
        return true;
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, SpscArrayQueue.MAX_LOOK_AHEAD_STEP);
    }
}

