/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.cql3.functions.types.AbstractGettableData;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.LocalDate;
import org.apache.cassandra.cql3.functions.types.SettableData;
import org.apache.cassandra.cql3.functions.types.TupleValue;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.functions.types.TypeTokens;
import org.apache.cassandra.cql3.functions.types.UDTValue;
import org.apache.cassandra.transport.ProtocolVersion;

abstract class AbstractData<T extends SettableData<T>>
extends AbstractGettableData
implements SettableData<T> {
    private final T wrapped;
    final ByteBuffer[] values;

    protected AbstractData(ProtocolVersion protocolVersion, int size) {
        super(protocolVersion);
        this.wrapped = this;
        this.values = new ByteBuffer[size];
    }

    protected AbstractData(ProtocolVersion protocolVersion, T wrapped, int size) {
        this(protocolVersion, wrapped, new ByteBuffer[size]);
    }

    protected AbstractData(ProtocolVersion protocolVersion, T wrapped, ByteBuffer[] values) {
        super(protocolVersion);
        this.wrapped = wrapped;
        this.values = values;
    }

    protected abstract int[] getAllIndexesOf(String var1);

    private T setValue(int i, ByteBuffer value) {
        this.values[i] = value;
        return this.wrapped;
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.values[i];
    }

    @Override
    protected int getIndexOf(String name) {
        return this.getAllIndexesOf(name)[0];
    }

    @Override
    public T setBool(int i, boolean v) {
        TypeCodec<Class<Boolean>> codec = this.codecFor(i, Boolean.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveBooleanCodec ? ((TypeCodec.PrimitiveBooleanCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Boolean>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setBool(String name, boolean v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setBool(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setByte(int i, byte v) {
        TypeCodec<Class<Byte>> codec = this.codecFor(i, Byte.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveByteCodec ? ((TypeCodec.PrimitiveByteCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Byte>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setByte(String name, byte v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setByte(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setShort(int i, short v) {
        TypeCodec<Class<Short>> codec = this.codecFor(i, Short.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveShortCodec ? ((TypeCodec.PrimitiveShortCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Short>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setShort(String name, short v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setShort(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setInt(int i, int v) {
        TypeCodec<Class<Integer>> codec = this.codecFor(i, Integer.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveIntCodec ? ((TypeCodec.PrimitiveIntCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Integer>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setInt(String name, int v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setInt(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setLong(int i, long v) {
        TypeCodec<Class<Long>> codec = this.codecFor(i, Long.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveLongCodec ? ((TypeCodec.PrimitiveLongCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Long>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setLong(String name, long v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setLong(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setTimestamp(int i, Date v) {
        return this.setValue(i, this.codecFor(i, Date.class).serialize((Class<Date>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setTimestamp(String name, Date v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setTimestamp(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setDate(int i, LocalDate v) {
        return this.setValue(i, this.codecFor(i, LocalDate.class).serialize((Class<LocalDate>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setDate(String name, LocalDate v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setDate(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setTime(int i, long v) {
        TypeCodec<Class<Long>> codec = this.codecFor(i, Long.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveLongCodec ? ((TypeCodec.PrimitiveLongCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Long>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setTime(String name, long v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setTime(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setFloat(int i, float v) {
        TypeCodec<Class<Float>> codec = this.codecFor(i, Float.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveFloatCodec ? ((TypeCodec.PrimitiveFloatCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Float>)((Object)Float.valueOf(v)), this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setFloat(String name, float v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setFloat(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setDouble(int i, double v) {
        TypeCodec<Class<Double>> codec = this.codecFor(i, Double.class);
        ByteBuffer bb = codec instanceof TypeCodec.PrimitiveDoubleCodec ? ((TypeCodec.PrimitiveDoubleCodec)codec).serializeNoBoxing(v, this.protocolVersion) : codec.serialize((Class<Double>)v, this.protocolVersion);
        return this.setValue(i, bb);
    }

    @Override
    public T setDouble(String name, double v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setDouble(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setString(int i, String v) {
        return this.setValue(i, this.codecFor(i, String.class).serialize((Class<String>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setString(String name, String v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setString(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setBytes(int i, ByteBuffer v) {
        return this.setValue(i, this.codecFor(i, ByteBuffer.class).serialize((Class<ByteBuffer>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setBytes(String name, ByteBuffer v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setBytes(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setBytesUnsafe(int i, ByteBuffer v) {
        return this.setValue(i, v == null ? null : v.duplicate());
    }

    @Override
    public T setBytesUnsafe(String name, ByteBuffer v) {
        ByteBuffer value = v == null ? null : v.duplicate();
        for (int i : this.getAllIndexesOf(name)) {
            this.setValue(i, value);
        }
        return this.wrapped;
    }

    @Override
    public T setVarint(int i, BigInteger v) {
        return this.setValue(i, this.codecFor(i, BigInteger.class).serialize((Class<BigInteger>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setVarint(String name, BigInteger v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setVarint(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setDecimal(int i, BigDecimal v) {
        return this.setValue(i, this.codecFor(i, BigDecimal.class).serialize((Class<BigDecimal>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setDecimal(String name, BigDecimal v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setDecimal(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setUUID(int i, UUID v) {
        return this.setValue(i, this.codecFor(i, UUID.class).serialize((Class<UUID>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setUUID(String name, UUID v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setUUID(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setInet(int i, InetAddress v) {
        return this.setValue(i, this.codecFor(i, InetAddress.class).serialize((Class<InetAddress>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setInet(String name, InetAddress v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setInet(i, v);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setList(int i, List<E> v) {
        return this.setValue(i, this.codecFor(i).serialize(v, this.protocolVersion));
    }

    @Override
    public <E> T setList(int i, List<E> v, Class<E> elementsClass) {
        return this.setValue(i, this.codecFor(i, TypeTokens.listOf(elementsClass)).serialize((TypeToken<List<E>>)v, this.protocolVersion));
    }

    @Override
    public <E> T setList(int i, List<E> v, TypeToken<E> elementsType) {
        return this.setValue(i, this.codecFor(i, TypeTokens.listOf(elementsType)).serialize((TypeToken<List<E>>)v, this.protocolVersion));
    }

    @Override
    public <E> T setList(String name, List<E> v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setList(i, (List)v);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setList(String name, List<E> v, Class<E> elementsClass) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setList(i, (List)v, (Class)elementsClass);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setList(String name, List<E> v, TypeToken<E> elementsType) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setList(i, (List)v, (TypeToken)elementsType);
        }
        return this.wrapped;
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v) {
        return this.setValue(i, this.codecFor(i).serialize(v, this.protocolVersion));
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v, Class<K> keysClass, Class<V> valuesClass) {
        return this.setValue(i, this.codecFor(i, TypeTokens.mapOf(keysClass, valuesClass)).serialize((TypeToken<Map<K, V>>)v, this.protocolVersion));
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return this.setValue(i, this.codecFor(i, TypeTokens.mapOf(keysType, valuesType)).serialize((TypeToken<Map<K, V>>)v, this.protocolVersion));
    }

    @Override
    public <K, V> T setMap(String name, Map<K, V> v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setMap(i, (Map)v);
        }
        return this.wrapped;
    }

    @Override
    public <K, V> T setMap(String name, Map<K, V> v, Class<K> keysClass, Class<V> valuesClass) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setMap(i, (Map)v, (Class)keysClass, (Class)valuesClass);
        }
        return this.wrapped;
    }

    @Override
    public <K, V> T setMap(String name, Map<K, V> v, TypeToken<K> keysType, TypeToken<V> valuesType) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setMap(i, (Map)v, (TypeToken)keysType, (TypeToken)valuesType);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setSet(int i, Set<E> v) {
        return this.setValue(i, this.codecFor(i).serialize(v, this.protocolVersion));
    }

    @Override
    public <E> T setSet(int i, Set<E> v, Class<E> elementsClass) {
        return this.setValue(i, this.codecFor(i, TypeTokens.setOf(elementsClass)).serialize((TypeToken<Set<E>>)v, this.protocolVersion));
    }

    @Override
    public <E> T setSet(int i, Set<E> v, TypeToken<E> elementsType) {
        return this.setValue(i, this.codecFor(i, TypeTokens.setOf(elementsType)).serialize((TypeToken<Set<E>>)v, this.protocolVersion));
    }

    @Override
    public <E> T setSet(String name, Set<E> v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setSet(i, (Set)v);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setSet(String name, Set<E> v, Class<E> elementsClass) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setSet(i, (Set)v, (Class)elementsClass);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setSet(String name, Set<E> v, TypeToken<E> elementsType) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setSet(i, (Set)v, (TypeToken)elementsType);
        }
        return this.wrapped;
    }

    @Override
    public T setUDTValue(int i, UDTValue v) {
        return this.setValue(i, this.codecFor(i, UDTValue.class).serialize((Class<UDTValue>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setUDTValue(String name, UDTValue v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setUDTValue(i, v);
        }
        return this.wrapped;
    }

    @Override
    public T setTupleValue(int i, TupleValue v) {
        return this.setValue(i, this.codecFor(i, TupleValue.class).serialize((Class<TupleValue>)((Object)v), this.protocolVersion));
    }

    @Override
    public T setTupleValue(String name, TupleValue v) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setTupleValue(i, v);
        }
        return this.wrapped;
    }

    @Override
    public <V> T set(int i, V v, Class<V> targetClass) {
        return (T)this.set(i, (Object)v, this.codecFor(i, targetClass));
    }

    @Override
    public <V> T set(String name, V v, Class<V> targetClass) {
        for (int i : this.getAllIndexesOf(name)) {
            this.set(i, (Object)v, (Class)targetClass);
        }
        return this.wrapped;
    }

    @Override
    public <V> T set(int i, V v, TypeToken<V> targetType) {
        return (T)this.set(i, (Object)v, this.codecFor(i, targetType));
    }

    @Override
    public <V> T set(String name, V v, TypeToken<V> targetType) {
        for (int i : this.getAllIndexesOf(name)) {
            this.set(i, (Object)v, (TypeToken)targetType);
        }
        return this.wrapped;
    }

    @Override
    public <V> T set(int i, V v, TypeCodec<V> codec) {
        this.checkType(i, codec.getCqlType().getName());
        return this.setValue(i, codec.serialize(v, this.protocolVersion));
    }

    @Override
    public <V> T set(String name, V v, TypeCodec<V> codec) {
        for (int i : this.getAllIndexesOf(name)) {
            this.set(i, (Object)v, (TypeCodec)codec);
        }
        return this.wrapped;
    }

    @Override
    public T setToNull(int i) {
        return this.setValue(i, null);
    }

    @Override
    public T setToNull(String name) {
        for (int i : this.getAllIndexesOf(name)) {
            this.setToNull(i);
        }
        return this.wrapped;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractData)) {
            return false;
        }
        AbstractData that = (AbstractData)o;
        if (this.values.length != that.values.length) {
            return false;
        }
        if (this.protocolVersion != that.protocolVersion) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            Object thatValue;
            DataType thatType;
            DataType thisType = this.getType(i);
            if (!thisType.equals(thatType = that.getType(i))) {
                return false;
            }
            Object thisValue = this.codecFor(i).deserialize(this.values[i], this.protocolVersion);
            if (Objects.equals(thisValue, thatValue = that.codecFor(i).deserialize(that.values[i], that.protocolVersion))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 31;
        for (int i = 0; i < this.values.length; ++i) {
            hash += this.values[i] == null ? 1 : this.codecFor(i).deserialize(this.values[i], this.protocolVersion).hashCode();
        }
        return hash;
    }
}

