/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.aggregation.GroupMaker;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class ResultSetBuilder {
    private final ResultSet resultSet;
    private final Selection.Selectors selectors;
    private final GroupMaker groupMaker;
    List<ByteBuffer> current;
    final long[] timestamps;
    final int[] ttls;

    public ResultSetBuilder(ResultSet.ResultMetadata metadata, Selection.Selectors selectors) {
        this(metadata, selectors, null);
    }

    public ResultSetBuilder(ResultSet.ResultMetadata metadata, Selection.Selectors selectors, GroupMaker groupMaker) {
        this.resultSet = new ResultSet(metadata.copy(), new ArrayList<List<ByteBuffer>>());
        this.selectors = selectors;
        this.groupMaker = groupMaker;
        this.timestamps = selectors.collectTimestamps() ? new long[selectors.numberOfFetchedColumns()] : null;
        int[] nArray = this.ttls = selectors.collectTTLs() ? new int[selectors.numberOfFetchedColumns()] : null;
        if (this.timestamps != null) {
            Arrays.fill(this.timestamps, Long.MIN_VALUE);
        }
        if (this.ttls != null) {
            Arrays.fill(this.ttls, -1);
        }
    }

    public void add(ByteBuffer v) {
        this.current.add(v);
    }

    public void add(Cell<?> c, int nowInSec) {
        if (c == null) {
            this.current.add(null);
            return;
        }
        this.current.add(this.value(c));
        if (this.timestamps != null) {
            this.timestamps[this.current.size() - 1] = c.timestamp();
        }
        if (this.ttls != null) {
            this.ttls[this.current.size() - 1] = this.remainingTTL(c, nowInSec);
        }
    }

    private int remainingTTL(Cell<?> c, int nowInSec) {
        if (!c.isExpiring()) {
            return -1;
        }
        int remaining = c.localDeletionTime() - nowInSec;
        return remaining >= 0 ? remaining : -1;
    }

    private <V> ByteBuffer value(Cell<V> c) {
        return c.isCounterCell() ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value(), c.accessor())) : c.buffer();
    }

    public void newRow(DecoratedKey partitionKey, Clustering<?> clustering) {
        boolean isNewAggregate;
        boolean bl = isNewAggregate = this.groupMaker == null || this.groupMaker.isNewGroup(partitionKey, clustering);
        if (this.current != null) {
            this.selectors.addInputRow(this);
            if (isNewAggregate) {
                this.resultSet.addRow(this.getOutputRow());
                this.selectors.reset();
            }
        }
        this.current = new ArrayList<ByteBuffer>(this.selectors.numberOfFetchedColumns());
        if (this.timestamps != null) {
            Arrays.fill(this.timestamps, Long.MIN_VALUE);
        }
        if (this.ttls != null) {
            Arrays.fill(this.ttls, -1);
        }
    }

    public ResultSet build() {
        if (this.current != null) {
            this.selectors.addInputRow(this);
            this.resultSet.addRow(this.getOutputRow());
            this.selectors.reset();
            this.current = null;
        }
        if (this.resultSet.isEmpty() && this.groupMaker != null && this.groupMaker.returnAtLeastOneRow()) {
            this.resultSet.addRow(this.getOutputRow());
        }
        return this.resultSet;
    }

    private List<ByteBuffer> getOutputRow() {
        return this.selectors.getOutputRow();
    }
}

