/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.function.LongPredicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.schema.CompactionParams;

public abstract class AbstractCompactionController
implements AutoCloseable {
    public final ColumnFamilyStore cfs;
    public final int gcBefore;
    public final CompactionParams.TombstoneOption tombstoneOption;

    public AbstractCompactionController(ColumnFamilyStore cfs, int gcBefore, CompactionParams.TombstoneOption tombstoneOption) {
        assert (cfs != null);
        this.cfs = cfs;
        this.gcBefore = gcBefore;
        this.tombstoneOption = tombstoneOption;
    }

    public abstract boolean compactingRepaired();

    public String getKeyspace() {
        return this.cfs.keyspace.getName();
    }

    public String getColumnFamily() {
        return this.cfs.name;
    }

    public Iterable<UnfilteredRowIterator> shadowSources(DecoratedKey key, boolean tombstoneOnly) {
        return null;
    }

    public abstract LongPredicate getPurgeEvaluator(DecoratedKey var1);
}

