/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;

public class ValueComparators {
    public final Comparator<byte[]> array;
    public final Comparator<ByteBuffer> buffer;

    public ValueComparators(Comparator<byte[]> array, Comparator<ByteBuffer> buffer) {
        this.array = array;
        this.buffer = buffer;
    }

    public Comparator getForAccessor(ValueAccessor accessor) {
        if (accessor == ByteArrayAccessor.instance) {
            return this.array;
        }
        if (accessor == ByteBufferAccessor.instance) {
            return this.buffer;
        }
        throw new UnsupportedOperationException("Unsupported accessor: " + accessor.getClass().getName());
    }
}

