/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.view.ViewBuilder;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class View {
    public static final String USAGE_WARNING = "Materialized views are experimental and are not recommended for production use.";
    private static final Logger logger = LoggerFactory.getLogger(View.class);
    public final String name;
    private volatile ViewMetadata definition;
    private final ColumnFamilyStore baseCfs;
    public volatile List<ColumnMetadata> baseNonPKColumnsInViewPK;
    private ViewBuilder builder;
    private SelectStatement select;
    private ReadQuery query;

    public View(ViewMetadata definition, ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
        this.name = definition.name();
        this.updateDefinition(definition);
    }

    public ViewMetadata getDefinition() {
        return this.definition;
    }

    public void updateDefinition(ViewMetadata definition) {
        this.definition = definition;
        ArrayList<ColumnMetadata> nonPKDefPartOfViewPK = new ArrayList<ColumnMetadata>();
        for (ColumnMetadata baseColumn : this.baseCfs.metadata.get().columns()) {
            ColumnMetadata viewColumn = this.getViewColumn(baseColumn);
            if (viewColumn == null || baseColumn.isPrimaryKeyColumn() || !viewColumn.isPrimaryKeyColumn()) continue;
            nonPKDefPartOfViewPK.add(baseColumn);
        }
        this.baseNonPKColumnsInViewPK = nonPKDefPartOfViewPK;
    }

    public ColumnMetadata getViewColumn(ColumnMetadata baseColumn) {
        return this.definition.metadata.getColumn(baseColumn.name);
    }

    public ColumnMetadata getBaseColumn(ColumnMetadata viewColumn) {
        ColumnMetadata baseColumn = this.baseCfs.metadata().getColumn(viewColumn.name);
        assert (baseColumn != null);
        return baseColumn;
    }

    public boolean mayBeAffectedBy(DecoratedKey partitionKey, Row update) {
        return this.getReadQuery().selectsClustering(partitionKey, (Clustering<?>)update.clustering());
    }

    public boolean matchesViewFilter(DecoratedKey partitionKey, Row baseRow, int nowInSec) {
        return this.getReadQuery().selectsClustering(partitionKey, (Clustering<?>)baseRow.clustering()) && this.getSelectStatement().rowFilterForInternalCalls().isSatisfiedBy(this.baseCfs.metadata(), partitionKey, baseRow, nowInSec);
    }

    SelectStatement getSelectStatement() {
        if (null == this.select) {
            SelectStatement.Parameters parameters = new SelectStatement.Parameters(Collections.emptyMap(), Collections.emptyList(), false, true, false);
            SelectStatement.RawStatement rawSelect = new SelectStatement.RawStatement(new QualifiedName(this.baseCfs.keyspace.getName(), this.baseCfs.name), parameters, this.selectClause(), this.definition.whereClause, null, null);
            rawSelect.setBindVariables(Collections.emptyList());
            this.select = rawSelect.prepare(true);
        }
        return this.select;
    }

    private List<RawSelector> selectClause() {
        return this.definition.metadata.columns().stream().map(c -> c.name.toString()).map(Selectable.RawIdentifier::forQuoted).map(c -> new RawSelector((Selectable.Raw)c, null)).collect(Collectors.toList());
    }

    ReadQuery getReadQuery() {
        if (this.query == null) {
            this.query = this.getSelectStatement().getQuery(QueryOptions.forInternalCalls(Collections.emptyList()), FBUtilities.nowInSeconds());
        }
        return this.query;
    }

    public synchronized void build() {
        this.stopBuild();
        this.builder = new ViewBuilder(this.baseCfs, this);
        this.builder.start();
    }

    synchronized void stopBuild() {
        if (this.builder != null) {
            logger.debug("Stopping current view builder due to schema change or truncate");
            this.builder.stop();
            this.builder = null;
        }
    }

    @Nullable
    public static TableMetadataRef findBaseTable(String keyspace, String viewName) {
        ViewMetadata view = Schema.instance.getView(keyspace, viewName);
        return view == null ? null : Schema.instance.getTableMetadataRef(view.baseTableId);
    }

    public static Iterable<ViewMetadata> findAll(String keyspace, String baseTable) {
        KeyspaceMetadata ksm = Schema.instance.getKeyspaceMetadata(keyspace);
        return Iterables.filter((Iterable)ksm.views, view -> view.baseTableName.equals(baseTable));
    }

    public boolean hasSamePrimaryKeyColumnsAsBaseTable() {
        return this.baseNonPKColumnsInViewPK.isEmpty();
    }

    public boolean enforceStrictLiveness() {
        return !this.baseNonPKColumnsInViewPK.isEmpty();
    }
}

