/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class StreamingMetrics {
    public static final String TYPE_NAME = "Streaming";
    private static final ConcurrentMap<InetAddressAndPort, StreamingMetrics> instances = new NonBlockingHashMap();
    @Deprecated
    public static final Counter activeStreamsOutbound = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "ActiveOutboundStreams", null));
    public static final Counter totalIncomingBytes = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "TotalIncomingBytes", null));
    public static final Counter totalOutgoingBytes = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "TotalOutgoingBytes", null));
    public static final Counter totalOutgoingRepairBytes = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "TotalOutgoingRepairBytes", null));
    public static final Counter totalOutgoingRepairSSTables = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Streaming", "TotalOutgoingRepairSSTables", null));
    public final Counter incomingBytes;
    public final Counter outgoingBytes;
    public final Timer incomingProcessTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StreamingMetrics get(InetAddressAndPort ip) {
        StreamingMetrics metrics = (StreamingMetrics)instances.get(ip);
        if (metrics == null) {
            ConcurrentMap<InetAddressAndPort, StreamingMetrics> concurrentMap = instances;
            synchronized (concurrentMap) {
                metrics = (StreamingMetrics)instances.get(ip);
                if (metrics == null) {
                    metrics = new StreamingMetrics(ip);
                    instances.put(ip, metrics);
                }
            }
        }
        return metrics;
    }

    public StreamingMetrics(InetAddressAndPort peer) {
        DefaultNameFactory factory = new DefaultNameFactory(TYPE_NAME, peer.toString().replace(':', '.'));
        this.incomingBytes = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("IncomingBytes"));
        this.outgoingBytes = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("OutgoingBytes"));
        this.incomingProcessTime = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName("IncomingProcessTime"));
    }
}

