/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.apache.cassandra.utils.Pair;

public interface Scheduler {
    default public <T> ListenableFuture<T> schedule(Supplier<ListenableFuture<T>> task, Executor executor) {
        return this.schedule(new Task<T>(task, executor), executor);
    }

    public <T> Task<T> schedule(Task<T> var1, Executor var2);

    public static Scheduler build(int concurrentValidations) {
        return concurrentValidations <= 0 ? new NoopScheduler() : new LimitedConcurrentScheduler(concurrentValidations);
    }

    public static class Task<T>
    extends AbstractFuture<T>
    implements Runnable {
        private final Supplier<ListenableFuture<T>> supplier;
        private final Executor executor;

        public Task(Supplier<ListenableFuture<T>> supplier, Executor executor) {
            this.supplier = supplier;
            this.executor = executor;
        }

        @Override
        public void run() {
            Futures.addCallback(this.supplier.get(), (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T result) {
                    this.set(result);
                }

                public void onFailure(Throwable t) {
                    this.setException(t);
                }
            }, (Executor)this.executor);
        }
    }

    public static final class LimitedConcurrentScheduler
    implements Scheduler {
        private final int concurrentValidations;
        @GuardedBy(value="this")
        private int inflight = 0;
        @GuardedBy(value="this")
        private final Queue<Pair<Task<?>, Executor>> tasks = new LinkedList();

        LimitedConcurrentScheduler(int concurrentValidations) {
            this.concurrentValidations = concurrentValidations;
        }

        @Override
        public synchronized <T> Task<T> schedule(Task<T> task, Executor executor) {
            this.tasks.offer(Pair.create(task, executor));
            this.maybeSchedule();
            return task;
        }

        private synchronized void onDone() {
            --this.inflight;
            this.maybeSchedule();
        }

        private void maybeSchedule() {
            if (this.inflight == this.concurrentValidations || this.tasks.isEmpty()) {
                return;
            }
            ++this.inflight;
            Pair<Task<?>, Executor> pair = this.tasks.poll();
            Futures.addCallback((ListenableFuture)((ListenableFuture)pair.left), (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    this.onDone();
                }

                public void onFailure(Throwable t) {
                    this.onDone();
                }
            }, (Executor)((Executor)pair.right));
            ((Executor)pair.right).execute((Runnable)pair.left);
        }
    }

    public static final class NoopScheduler
    implements Scheduler {
        @Override
        public <T> Task<T> schedule(Task<T> task, Executor executor) {
            executor.execute(task);
            return task;
        }
    }
}

