/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

public enum StreamOperation {
    OTHER("Other"),
    RESTORE_REPLICA_COUNT("Restore replica count", false),
    DECOMMISSION("Unbootstrap", false),
    RELOCATION("Relocation", false),
    BOOTSTRAP("Bootstrap", false),
    REBUILD("Rebuild", false),
    BULK_LOAD("Bulk Load"),
    REPAIR("Repair");

    private final String description;
    private final boolean requiresViewBuild;

    private StreamOperation(String description) {
        this(description, true);
    }

    private StreamOperation(String description, boolean requiresViewBuild) {
        this.description = description;
        this.requiresViewBuild = requiresViewBuild;
    }

    public static StreamOperation fromString(String text) {
        for (StreamOperation b : StreamOperation.values()) {
            if (!b.description.equalsIgnoreCase(text)) continue;
            return b;
        }
        return OTHER;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean requiresViewBuild() {
        return this.requiresViewBuild;
    }
}

