/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.progress.jmx;

import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.apache.cassandra.utils.progress.ProgressListener;

public abstract class JMXNotificationProgressListener
implements ProgressListener,
NotificationListener {
    public abstract boolean isInterestedIn(String var1);

    public void handleNotificationLost(long timestamp, String message) {
    }

    public void handleConnectionClosed(long timestamp, String message) {
    }

    public void handleConnectionFailed(long timestamp, String message) {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        switch (notification.getType()) {
            case "progress": {
                String tag = (String)notification.getSource();
                if (!this.isInterestedIn(tag)) break;
                Map progress = (Map)notification.getUserData();
                String message = notification.getMessage();
                ProgressEvent event = new ProgressEvent(ProgressEventType.values()[(Integer)progress.get("type")], (Integer)progress.get("progressCount"), (Integer)progress.get("total"), message);
                this.progress(tag, event);
                break;
            }
            case "jmx.remote.connection.notifs.lost": {
                this.handleNotificationLost(notification.getTimeStamp(), notification.getMessage());
                break;
            }
            case "jmx.remote.connection.failed": {
                this.handleConnectionFailed(notification.getTimeStamp(), notification.getMessage());
                break;
            }
            case "jmx.remote.connection.closed": {
                this.handleConnectionClosed(notification.getTimeStamp(), notification.getMessage());
            }
        }
    }
}

