/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.shortestpath;

import java.util.LinkedList;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathResult;
import org.psjava.ds.graph.DirectedEdge;
import org.psjava.ds.map.Map;
import org.psjava.ds.numbersystrem.InfinitableNumber;
import org.psjava.util.AssertStatus;

public class SingleSourceShortestPathResultFactory {
    public static <V, E extends DirectedEdge<V>, W> SingleSourceShortestPathResult<V, W, E> create(final V start, final Map<V, InfinitableNumber<W>> distance, final Map<V, E> previous) {
        return new SingleSourceShortestPathResult<V, W, E>(){

            @Override
            public W getDistance(V to) {
                this.assertReachable(to);
                return ((InfinitableNumber)distance.get(to)).getValue();
            }

            @Override
            public Iterable<E> getPath(V to) {
                this.assertReachable(to);
                LinkedList r = new LinkedList();
                Object v = to;
                while (!v.equals(start)) {
                    r.addFirst(previous.get(v));
                    v = ((DirectedEdge)previous.get(v)).from();
                }
                return r;
            }

            @Override
            public boolean isReachable(V to) {
                return !((InfinitableNumber)distance.get(to)).isInfinity();
            }

            private void assertReachable(V to) {
                AssertStatus.assertTrue(this.isReachable(to), "Not reachable");
            }
        };
    }

    private SingleSourceShortestPathResultFactory() {
    }
}

