/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InvalidQueryException
extends QueryValidationException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public InvalidQueryException(String msg) {
        this(null, msg);
    }

    public InvalidQueryException(EndPoint endPoint, String msg) {
        super(msg);
        this.endPoint = endPoint;
    }

    public InvalidQueryException(String msg, Throwable cause) {
        this(null, msg, cause);
    }

    public InvalidQueryException(EndPoint endPoint, String msg, Throwable cause) {
        super(msg, cause);
        this.endPoint = endPoint;
    }

    @Override
    public DriverException copy() {
        return new InvalidQueryException(this.getEndPoint(), this.getMessage(), this);
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }
}

