/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.ColumnType;
import com.datastax.driver.core.schemabuilder.SchemaStatement;

public final class UDTType
implements ColumnType {
    private final String asCQLString;

    private UDTType(String asCQLString) {
        this.asCQLString = asCQLString;
    }

    @Override
    public String asCQLString() {
        return this.asCQLString;
    }

    static UDTType frozen(String udtName) {
        SchemaStatement.validateNotEmpty(udtName, "UDT name");
        return new UDTType("frozen<" + udtName + ">");
    }

    static UDTType list(UDTType elementType) {
        return new UDTType("list<" + elementType.asCQLString() + ">");
    }

    static UDTType set(UDTType elementType) {
        return new UDTType("set<" + elementType.asCQLString() + ">");
    }

    static UDTType mapWithUDTKey(UDTType keyType, DataType valueType) {
        return new UDTType("map<" + keyType.asCQLString() + ", " + valueType + ">");
    }

    static UDTType mapWithUDTValue(DataType keyType, UDTType valueType) {
        return new UDTType("map<" + keyType + ", " + valueType.asCQLString() + ">");
    }

    static UDTType mapWithUDTKeyAndValue(UDTType keyType, UDTType valueType) {
        return new UDTType("map<" + keyType.asCQLString() + ", " + valueType.asCQLString() + ">");
    }

    static UDTType literal(String literal) {
        SchemaStatement.validateNotEmpty(literal, "UDT type literal");
        return new UDTType(literal);
    }
}

