/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.gridkit.util.formating.NumberFormat;

public class SimpleNumberFormatter
implements NumberFormat {
    public static final SimpleNumberFormatter DEFAULT = new SimpleNumberFormatter("");
    private final LongFormatter lf;
    private final DoubleFormatter df;

    public SimpleNumberFormatter(String format) {
        this(format, TimeZone.getDefault());
    }

    public SimpleNumberFormatter(String format, TimeZone tz) {
        if (format.length() == 0) {
            this.lf = new DefaultLongFormatter();
            this.df = new DefaultDoubleFormatter();
        } else if (format.startsWith("D")) {
            DecimalFormat fmt = new DecimalFormat(format.substring(1));
            this.lf = new DecimalFormatLong(fmt);
            this.df = new DecimalFormatDouble(fmt);
        } else if (format.startsWith("T")) {
            SimpleDateFormat sdf = new SimpleDateFormat(format.substring(1));
            sdf.setTimeZone(tz);
            this.lf = new SDFFormatter(sdf);
            this.df = new D2L(this.lf);
        } else if (format.startsWith("F")) {
            this.lf = new JavaFormatterLong(format.substring(1));
            this.df = new JavaFormatterDouble(format.substring(1));
        } else {
            throw new IllegalArgumentException("Format spec should start with D, T or F");
        }
    }

    @Override
    public String formatLong(long v) {
        return this.lf.formatLong(v);
    }

    @Override
    public String formatDouble(double v) {
        return this.df.formatDouble(v);
    }

    private static class D2L
    extends DoubleFormatter {
        private final LongFormatter lf;

        public D2L(LongFormatter lf) {
            this.lf = lf;
        }

        @Override
        public String formatDouble(double v) {
            return this.lf.formatLong((long)v);
        }
    }

    private static class JavaFormatterDouble
    extends DoubleFormatter {
        private final String fmt;

        public JavaFormatterDouble(String fmt) {
            this.fmt = fmt;
        }

        @Override
        public String formatDouble(double v) {
            return String.format(Locale.ROOT, this.fmt, v);
        }
    }

    private static class JavaFormatterLong
    extends LongFormatter {
        private final String fmt;

        public JavaFormatterLong(String fmt) {
            this.fmt = fmt;
        }

        @Override
        public String formatLong(long v) {
            return String.format(Locale.ROOT, this.fmt, v);
        }
    }

    private static class DecimalFormatDouble
    extends DoubleFormatter {
        private final DecimalFormat fmt;

        public DecimalFormatDouble(DecimalFormat fmt) {
            this.fmt = fmt;
        }

        @Override
        public String formatDouble(double v) {
            return this.fmt.format(v);
        }
    }

    private static class DecimalFormatLong
    extends LongFormatter {
        private final DecimalFormat fmt;

        public DecimalFormatLong(DecimalFormat fmt) {
            this.fmt = fmt;
        }

        @Override
        public String formatLong(long v) {
            return this.fmt.format(v);
        }
    }

    private static class SDFFormatter
    extends LongFormatter {
        private final SimpleDateFormat sdf;

        public SDFFormatter(SimpleDateFormat sdf) {
            this.sdf = sdf;
        }

        @Override
        public String formatLong(long v) {
            return this.sdf.format(v);
        }
    }

    private static class DefaultDoubleFormatter
    extends DoubleFormatter {
        private DefaultDoubleFormatter() {
        }

        @Override
        public String formatDouble(double v) {
            return String.valueOf(v);
        }
    }

    private static class DefaultLongFormatter
    extends LongFormatter {
        private DefaultLongFormatter() {
        }

        @Override
        public String formatLong(long v) {
            return String.valueOf(v);
        }
    }

    private static abstract class DoubleFormatter {
        private DoubleFormatter() {
        }

        public abstract String formatDouble(double var1);
    }

    private static abstract class LongFormatter {
        private LongFormatter() {
        }

        public abstract String formatLong(long var1);
    }
}

