/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcmon;

import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.gridkit.jvmtool.gcmon.GarbageCollectionEventConsumer;
import org.gridkit.jvmtool.gcmon.GcEventPoller;

public class GcEventSubscriber
extends GcEventPoller {
    private static Listener LISTENER = new Listener();

    public GcEventSubscriber(MBeanServerConnection mserver, GarbageCollectionEventConsumer eventSink) {
        super(mserver, eventSink);
    }

    public boolean subscribe() {
        boolean ok = true;
        for (GcEventPoller.GcTracker tracker : this.trackers) {
            try {
                this.subscribeTracker(tracker);
            }
            catch (Exception e) {
                ok = false;
                this.unsubscribe();
                break;
            }
        }
        return ok;
    }

    public void unsubscribe() {
        for (GcEventPoller.GcTracker tracker : this.trackers) {
            try {
                this.mserver.removeNotificationListener(tracker.name, LISTENER, null, (Object)tracker);
            }
            catch (Exception exception) {}
        }
    }

    protected void subscribeTracker(GcEventPoller.GcTracker tracker) throws IOException, JMException {
        this.mserver.addNotificationListener(tracker.name, LISTENER, null, (Object)tracker);
        tracker.capture();
    }

    private static class Listener
    implements NotificationListener {
        private Listener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            try {
                GcEventPoller.GcTracker tracker = (GcEventPoller.GcTracker)handback;
                CompositeData cdata = (CompositeData)notification.getUserData();
                CompositeData gcInfo = (CompositeData)cdata.get("gcInfo");
                tracker.processGcEvent(gcInfo);
            }
            catch (JMException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

