/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.function.LongPredicate;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PurgeFunction;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.MoreRows;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;

@NotThreadSafe
class RepairedDataInfo {
    public static final RepairedDataInfo NO_OP_REPAIRED_DATA_INFO = new RepairedDataInfo(null){

        @Override
        public UnfilteredPartitionIterator withRepairedDataInfo(UnfilteredPartitionIterator iterator) {
            return iterator;
        }

        @Override
        public UnfilteredRowIterator withRepairedDataInfo(UnfilteredRowIterator iterator) {
            return iterator;
        }

        @Override
        public UnfilteredPartitionIterator extend(UnfilteredPartitionIterator partitions, DataLimits.Counter limit) {
            return partitions;
        }
    };
    private Digest perPartitionDigest;
    private Digest perCommandDigest;
    private boolean isConclusive = true;
    private ByteBuffer calculatedDigest = null;
    private RepairedDataPurger purger;
    private boolean isFullyPurged = true;
    private UnfilteredPartitionIterator postLimitPartitions = null;
    private final DataLimits.Counter repairedCounter;
    private UnfilteredRowIterator currentPartition;
    private TableMetrics metrics;

    public RepairedDataInfo(DataLimits.Counter repairedCounter) {
        this.repairedCounter = repairedCounter;
    }

    ByteBuffer getDigest() {
        if (this.calculatedDigest != null) {
            return this.calculatedDigest;
        }
        this.calculatedDigest = this.perCommandDigest == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(this.perCommandDigest.digest());
        return this.calculatedDigest;
    }

    void prepare(ColumnFamilyStore cfs, long nowInSec, long oldestUnrepairedTombstone) {
        this.purger = new RepairedDataPurger(cfs, nowInSec, oldestUnrepairedTombstone);
        this.metrics = cfs.metric;
    }

    void finalize(UnfilteredPartitionIterator postLimitPartitions) {
        this.postLimitPartitions = postLimitPartitions;
    }

    boolean isConclusive() {
        return this.isConclusive;
    }

    void markInconclusive() {
        this.isConclusive = false;
    }

    private void onNewPartition(UnfilteredRowIterator partition) {
        assert (this.purger != null);
        this.purger.setCurrentKey(partition.partitionKey());
        this.purger.setIsReverseOrder(partition.isReverseOrder());
        this.currentPartition = partition;
    }

    private Digest getPerPartitionDigest() {
        if (this.perPartitionDigest == null) {
            this.perPartitionDigest = Digest.forRepairedDataTracking();
        }
        return this.perPartitionDigest;
    }

    public UnfilteredPartitionIterator withRepairedDataInfo(UnfilteredPartitionIterator iterator) {
        class WithTracking
        extends Transformation<UnfilteredRowIterator> {
            WithTracking() {
            }

            @Override
            protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
                return RepairedDataInfo.this.withRepairedDataInfo(partition);
            }
        }
        return Transformation.apply(iterator, new WithTracking());
    }

    public UnfilteredRowIterator withRepairedDataInfo(UnfilteredRowIterator iterator) {
        if (this.repairedCounter.isDone()) {
            return iterator;
        }
        class WithTracking
        extends Transformation<UnfilteredRowIterator> {
            WithTracking() {
            }

            @Override
            protected DecoratedKey applyToPartitionKey(DecoratedKey key) {
                RepairedDataInfo.this.getPerPartitionDigest().update(key.getKey());
                return key;
            }

            @Override
            protected DeletionTime applyToDeletion(DeletionTime deletionTime) {
                if (RepairedDataInfo.this.repairedCounter.isDone()) {
                    return deletionTime;
                }
                assert (RepairedDataInfo.this.purger != null);
                DeletionTime purged = RepairedDataInfo.this.purger.applyToDeletion(deletionTime);
                if (!purged.isLive()) {
                    RepairedDataInfo.this.isFullyPurged = false;
                }
                purged.digest(RepairedDataInfo.this.getPerPartitionDigest());
                return deletionTime;
            }

            @Override
            protected RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
                if (RepairedDataInfo.this.repairedCounter.isDone()) {
                    return marker;
                }
                assert (RepairedDataInfo.this.purger != null);
                RangeTombstoneMarker purged = RepairedDataInfo.this.purger.applyToMarker(marker);
                if (purged != null) {
                    RepairedDataInfo.this.isFullyPurged = false;
                    purged.digest(RepairedDataInfo.this.getPerPartitionDigest());
                }
                return marker;
            }

            @Override
            protected Row applyToStatic(Row row) {
                return this.applyToRow(row);
            }

            @Override
            protected Row applyToRow(Row row) {
                if (RepairedDataInfo.this.repairedCounter.isDone()) {
                    return row;
                }
                assert (RepairedDataInfo.this.purger != null);
                Row purged = RepairedDataInfo.this.purger.applyToRow(row);
                if (purged != null && !purged.isEmpty()) {
                    RepairedDataInfo.this.isFullyPurged = false;
                    purged.digest(RepairedDataInfo.this.getPerPartitionDigest());
                }
                return row;
            }

            @Override
            protected void onPartitionClose() {
                if (RepairedDataInfo.this.perPartitionDigest != null) {
                    if (!RepairedDataInfo.this.isFullyPurged) {
                        if (RepairedDataInfo.this.perCommandDigest == null) {
                            RepairedDataInfo.this.perCommandDigest = Digest.forRepairedDataTracking();
                        }
                        byte[] partitionDigest = RepairedDataInfo.this.perPartitionDigest.digest();
                        RepairedDataInfo.this.perCommandDigest.update(partitionDigest, 0, partitionDigest.length);
                    }
                    RepairedDataInfo.this.perPartitionDigest = null;
                }
                RepairedDataInfo.this.isFullyPurged = true;
            }
        }
        UnfilteredRowIterator tracked = this.repairedCounter.applyTo(Transformation.apply(iterator, new WithTracking()));
        this.onNewPartition(tracked);
        return tracked;
    }

    public UnfilteredPartitionIterator extend(UnfilteredPartitionIterator partitions, final DataLimits.Counter limit) {
        if (this.metrics == null || this.repairedCounter.isDone()) {
            return partitions;
        }
        class OverreadRepairedData
        extends Transformation<UnfilteredRowIterator>
        implements MoreRows<UnfilteredRowIterator> {
            OverreadRepairedData() {
            }

            @Override
            protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
                return MoreRows.extend(partition, this, partition.columns());
            }

            @Override
            public UnfilteredRowIterator moreContents() {
                if (!limit.isDone() || RepairedDataInfo.this.repairedCounter.isDone()) {
                    return null;
                }
                long countBeforeOverreads = RepairedDataInfo.this.repairedCounter.counted();
                long overreadStartTime = Clock.Global.nanoTime();
                if (RepairedDataInfo.this.currentPartition != null) {
                    this.consumePartition(RepairedDataInfo.this.currentPartition, RepairedDataInfo.this.repairedCounter);
                }
                if (RepairedDataInfo.this.postLimitPartitions != null) {
                    while (RepairedDataInfo.this.postLimitPartitions.hasNext() && !RepairedDataInfo.this.repairedCounter.isDone()) {
                        this.consumePartition((UnfilteredRowIterator)RepairedDataInfo.this.postLimitPartitions.next(), RepairedDataInfo.this.repairedCounter);
                    }
                }
                long rows = (long)RepairedDataInfo.this.repairedCounter.counted() - countBeforeOverreads;
                long nanos = Clock.Global.nanoTime() - overreadStartTime;
                RepairedDataInfo.this.metrics.repairedDataTrackingOverreadRows.update(rows);
                RepairedDataInfo.this.metrics.repairedDataTrackingOverreadTime.update(nanos, TimeUnit.NANOSECONDS);
                Tracing.trace("Read {} additional rows of repaired data for tracking in {}ps", (Object)rows, (Object)TimeUnit.NANOSECONDS.toMicros(nanos));
                return null;
            }

            private void consumePartition(UnfilteredRowIterator partition, DataLimits.Counter counter) {
                if (partition == null) {
                    return;
                }
                while (!counter.isDone() && partition.hasNext()) {
                    partition.next();
                }
                partition.close();
            }
        }
        return Transformation.apply(partitions, new OverreadRepairedData());
    }

    private static class RepairedDataPurger
    extends PurgeFunction {
        RepairedDataPurger(ColumnFamilyStore cfs, long nowInSec, long oldestUnrepairedTombstone) {
            super(nowInSec, cfs.gcBefore(nowInSec), oldestUnrepairedTombstone, cfs.getCompactionStrategyManager().onlyPurgeRepairedTombstones(), cfs.metadata.get().enforceStrictLiveness());
        }

        @Override
        protected LongPredicate getPurgeEvaluator() {
            return time -> true;
        }

        void setCurrentKey(DecoratedKey key) {
            super.onNewPartition(key);
        }

        void setIsReverseOrder(boolean isReverseOrder) {
            super.setReverseOrder(isReverseOrder);
        }

        @Override
        public DeletionTime applyToDeletion(DeletionTime deletionTime) {
            return super.applyToDeletion(deletionTime);
        }

        @Override
        public Row applyToRow(Row row) {
            return super.applyToRow(row);
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            return super.applyToMarker(marker);
        }
    }
}

