/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.compaction.ActiveCompactionsTracker;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;

public class ActiveCompactions
implements ActiveCompactionsTracker {
    private final Set<CompactionInfo.Holder> compactions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public List<CompactionInfo.Holder> getCompactions() {
        return new ArrayList<CompactionInfo.Holder>(this.compactions);
    }

    @Override
    public void beginCompaction(CompactionInfo.Holder ci) {
        this.compactions.add(ci);
    }

    @Override
    public void finishCompaction(CompactionInfo.Holder ci) {
        this.compactions.remove(ci);
        CompactionManager.instance.getMetrics().bytesCompacted.inc(ci.getCompactionInfo().getTotal());
        CompactionManager.instance.getMetrics().totalCompactionsCompleted.mark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, Long> estimatedRemainingWriteBytes() {
        Set<CompactionInfo.Holder> set = this.compactions;
        synchronized (set) {
            HashMap<File, Long> writeBytesPerSSTableDir = new HashMap<File, Long>();
            for (CompactionInfo.Holder holder : this.compactions) {
                CompactionInfo compactionInfo = holder.getCompactionInfo();
                List<File> directories = compactionInfo.getTargetDirectories();
                if (directories == null || directories.isEmpty()) continue;
                long remainingWriteBytesPerDataDir = compactionInfo.estimatedRemainingWriteBytes() / (long)directories.size();
                for (File directory : directories) {
                    writeBytesPerSSTableDir.merge(directory, remainingWriteBytesPerDataDir, Long::sum);
                }
            }
            return writeBytesPerSSTableDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CompactionInfo> getCompactionsForSSTable(SSTableReader sstable, OperationType compactionType) {
        ArrayList<CompactionInfo> toReturn = null;
        Set<CompactionInfo.Holder> set = this.compactions;
        synchronized (set) {
            for (CompactionInfo.Holder holder : this.compactions) {
                CompactionInfo compactionInfo = holder.getCompactionInfo();
                if (!compactionInfo.getSSTables().contains(sstable) || compactionInfo.getTaskType() != compactionType) continue;
                if (toReturn == null) {
                    toReturn = new ArrayList<CompactionInfo>();
                }
                toReturn.add(compactionInfo);
            }
        }
        return toReturn;
    }
}

