/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.agrona.collections.IntArrayList;
import org.apache.lucene.util.RamUsageEstimator;

public class VectorPostings<T> {
    private final List<T> postings;
    private volatile int ordinal = -1;
    private volatile IntArrayList rowIds;

    public VectorPostings(T firstKey) {
        this.postings = new CopyOnWriteArrayList<T>(List.of(firstKey));
    }

    void setOrdinal(int ordinal) {
        assert (this.ordinal == -1) : String.format("ordinal already set to %d; attempted to set to %d", this.ordinal, ordinal);
        this.ordinal = ordinal;
    }

    public boolean add(T key) {
        for (T existing : this.postings) {
            if (!existing.equals(key)) continue;
            return false;
        }
        this.postings.add(key);
        return true;
    }

    public boolean shouldAppendDeletedOrdinal() {
        return !this.postings.isEmpty() && this.rowIds != null && this.rowIds.isEmpty();
    }

    public void computeRowIds(Function<T, Integer> postingTransformer) {
        Preconditions.checkState((this.rowIds == null ? 1 : 0) != 0);
        IntArrayList ids = new IntArrayList(this.postings.size(), -1);
        for (T key : this.postings) {
            int rowId = postingTransformer.apply(key);
            if (rowId < 0) continue;
            ids.add(Integer.valueOf(rowId));
        }
        this.rowIds = ids;
    }

    public IntArrayList getRowIds() {
        Preconditions.checkNotNull((Object)this.rowIds);
        return this.rowIds;
    }

    public long remove(T key) {
        long bytesUsed = this.ramBytesUsed();
        this.postings.remove(key);
        return bytesUsed - this.ramBytesUsed();
    }

    public long ramBytesUsed() {
        return VectorPostings.emptyBytesUsed() + (long)this.postings.size() * VectorPostings.bytesPerPosting();
    }

    public static long emptyBytesUsed() {
        long REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        long AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        return 4L + REF_BYTES + AH_BYTES;
    }

    public static long bytesPerPosting() {
        long REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        return REF_BYTES + 16L + REF_BYTES;
    }

    public int size() {
        return this.postings.size();
    }

    public List<T> getPostings() {
        return this.postings;
    }

    public boolean isEmpty() {
        return this.postings.isEmpty();
    }

    public int getOrdinal() {
        assert (this.ordinal >= 0) : "ordinal not set";
        return this.ordinal;
    }
}

