/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.GaugeProvider;
import org.apache.cassandra.io.sstable.IScrubber;
import org.apache.cassandra.io.sstable.MetricsProviders;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.filter.BloomFilterMetrics;
import org.apache.cassandra.io.sstable.format.AbstractSSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.SortedTableScrubber;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.bti.BtiTableScrubber;
import org.apache.cassandra.io.sstable.format.bti.BtiTableWriter;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BtiFormat
extends AbstractSSTableFormat<BtiTableReader, BtiTableWriter> {
    private static final Logger logger = LoggerFactory.getLogger(BtiFormat.class);
    public static final String NAME = "bti";
    private final Version latestVersion = new BtiVersion(this, "da");
    static final BtiTableReaderFactory readerFactory = new BtiTableReaderFactory();
    static final BtiTableWriterFactory writerFactory = new BtiTableWriterFactory();

    public BtiFormat(Map<String, String> options) {
        super(NAME, options);
    }

    public static boolean is(SSTableFormat<?, ?> format) {
        return format.name().equals(NAME);
    }

    public static boolean isSelected() {
        return BtiFormat.is(DatabaseDescriptor.getSelectedSSTableFormat());
    }

    @Override
    public Version getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public Version getVersion(String version) {
        return new BtiVersion(this, version);
    }

    public BtiTableWriterFactory getWriterFactory() {
        return writerFactory;
    }

    public BtiTableReaderFactory getReaderFactory() {
        return readerFactory;
    }

    @Override
    public Set<Component> primaryComponents() {
        return Components.PRIMARY_COMPONENTS;
    }

    @Override
    public Set<Component> batchComponents() {
        return Components.BATCH_COMPONENTS;
    }

    @Override
    public Set<Component> uploadComponents() {
        return Components.UPLOAD_COMPONENTS;
    }

    @Override
    public Set<Component> mutableComponents() {
        return Components.MUTABLE_COMPONENTS;
    }

    @Override
    public Set<Component> allComponents() {
        return Components.ALL_COMPONENTS;
    }

    @Override
    public Set<Component> generatedOnLoadComponents() {
        return Components.GENERATED_ON_LOAD_COMPONENTS;
    }

    @Override
    public SSTableFormat.KeyCacheValueSerializer<BtiTableReader, TrieIndexEntry> getKeyCacheValueSerializer() {
        throw new AssertionError((Object)"BTI sstables do not use key cache");
    }

    @Override
    public IScrubber getScrubber(ColumnFamilyStore cfs, LifecycleTransaction transaction, OutputHandler outputHandler, IScrubber.Options options) {
        Preconditions.checkArgument((boolean)cfs.metadata().equals(transaction.onlyOne().metadata()), (Object)"SSTable metadata does not match current definition");
        return new BtiTableScrubber(cfs, transaction, outputHandler, options);
    }

    @Override
    public MetricsProviders getFormatSpecificMetricsProviders() {
        return BtiTableSpecificMetricsProviders.instance;
    }

    @Override
    public void deleteOrphanedComponents(Descriptor descriptor, Set<Component> components) {
        SortedTableScrubber.deleteOrphanedComponents(descriptor, components);
    }

    private void delete(Descriptor desc, List<Component> components) {
        logger.info("Deleting sstable: {}", (Object)desc);
        if (components.remove(SSTableFormat.Components.DATA)) {
            components.add(0, SSTableFormat.Components.DATA);
        }
        for (Component component : components) {
            logger.trace("Deleting component {} of {}", (Object)component, (Object)desc);
            desc.fileFor(component).deleteIfExists();
        }
    }

    @Override
    public void delete(Descriptor desc) {
        try {
            this.delete(desc, Lists.newArrayList((Iterable)Sets.intersection(this.allComponents(), desc.discoverComponents())));
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
        }
    }

    public static class BtiFormatFactory
    implements SSTableFormat.Factory {
        @Override
        public String name() {
            return BtiFormat.NAME;
        }

        @Override
        public SSTableFormat<?, ?> getInstance(Map<String, String> options) {
            return new BtiFormat(options);
        }
    }

    private static class BtiTableSpecificMetricsProviders
    implements MetricsProviders {
        private static final BtiTableSpecificMetricsProviders instance = new BtiTableSpecificMetricsProviders();
        private final Iterable<GaugeProvider<?>> gaugeProviders = BloomFilterMetrics.instance.getGaugeProviders();

        private BtiTableSpecificMetricsProviders() {
        }

        @Override
        public Iterable<GaugeProvider<?>> getGaugeProviders() {
            return this.gaugeProviders;
        }
    }

    static class BtiVersion
    extends Version {
        public static final String current_version = "da";
        public static final String earliest_supported_version = "da";
        private final boolean isLatestVersion;
        private final int correspondingMessagingVersion;

        BtiVersion(BtiFormat format, String version) {
            super(format, version);
            this.isLatestVersion = version.compareTo("da") == 0;
            this.correspondingMessagingVersion = 13;
        }

        @Override
        public boolean isLatestVersion() {
            return this.isLatestVersion;
        }

        @Override
        public int correspondingMessagingVersion() {
            return this.correspondingMessagingVersion;
        }

        @Override
        public boolean hasCommitLogLowerBound() {
            return true;
        }

        @Override
        public boolean hasCommitLogIntervals() {
            return true;
        }

        @Override
        public boolean hasMaxCompressedLength() {
            return true;
        }

        @Override
        public boolean hasPendingRepair() {
            return true;
        }

        @Override
        public boolean hasIsTransient() {
            return true;
        }

        @Override
        public boolean hasMetadataChecksum() {
            return true;
        }

        @Override
        public boolean hasOldBfFormat() {
            return false;
        }

        @Override
        public boolean hasAccurateMinMax() {
            return true;
        }

        @Override
        public boolean hasLegacyMinMax() {
            return false;
        }

        @Override
        public boolean hasOriginatingHostId() {
            return true;
        }

        @Override
        public boolean hasImprovedMinMax() {
            return true;
        }

        @Override
        public boolean hasTokenSpaceCoverage() {
            return true;
        }

        @Override
        public boolean hasPartitionLevelDeletionsPresenceMarker() {
            return true;
        }

        @Override
        public boolean hasKeyRange() {
            return true;
        }

        @Override
        public boolean isCompatible() {
            return this.version.compareTo("da") >= 0 && this.version.charAt(0) <= "da".charAt(0);
        }

        @Override
        public boolean isCompatibleForStreaming() {
            return this.isCompatible() && this.version.charAt(0) == "da".charAt(0);
        }

        @Override
        public boolean hasUIntDeletionTime() {
            return true;
        }
    }

    static class BtiTableWriterFactory
    implements SSTableFormat.SSTableWriterFactory<BtiTableWriter, BtiTableWriter.Builder> {
        BtiTableWriterFactory() {
        }

        @Override
        public BtiTableWriter.Builder builder(Descriptor descriptor) {
            return new BtiTableWriter.Builder(descriptor);
        }

        @Override
        public long estimateSize(SSTableWriter.SSTableSizeParameters parameters) {
            return (long)((double)(parameters.partitionCount() * 8L + parameters.partitionKeysSize() + parameters.dataSize()) * 1.2);
        }
    }

    static class BtiTableReaderFactory
    implements SSTableFormat.SSTableReaderFactory<BtiTableReader, BtiTableReader.Builder> {
        BtiTableReaderFactory() {
        }

        @Override
        public SSTableReader.Builder<BtiTableReader, BtiTableReader.Builder> builder(Descriptor descriptor) {
            return new BtiTableReader.Builder(descriptor);
        }

        @Override
        public SSTableReaderLoadingBuilder<BtiTableReader, BtiTableReader.Builder> loadingBuilder(Descriptor descriptor, TableMetadataRef tableMetadataRef, Set<Component> components) {
            return new BtiTableReaderLoadingBuilder((SSTable.Builder<?, ?>)((SSTable.Builder)new SSTable.Builder(descriptor).setTableMetadataRef(tableMetadataRef)).setComponents(components));
        }

        @Override
        public Pair<DecoratedKey, DecoratedKey> readKeyRange(Descriptor descriptor, IPartitioner partitioner) throws IOException {
            return PartitionIndex.readFirstAndLastKey(descriptor.fileFor(Components.PARTITION_INDEX), partitioner);
        }

        @Override
        public Class<BtiTableReader> getReaderClass() {
            return BtiTableReader.class;
        }
    }

    public static class Components
    extends SSTableFormat.Components {
        public static final Component PARTITION_INDEX = Types.PARTITION_INDEX.getSingleton();
        public static final Component ROW_INDEX = Types.ROW_INDEX.getSingleton();
        private static final Set<Component> PRIMARY_COMPONENTS = ImmutableSet.of((Object)DATA, (Object)PARTITION_INDEX);
        private static final Set<Component> MUTABLE_COMPONENTS = ImmutableSet.of((Object)STATS);
        private static final Set<Component> UPLOAD_COMPONENTS = ImmutableSet.of((Object)DATA, (Object)PARTITION_INDEX, (Object)ROW_INDEX, (Object)COMPRESSION_INFO, (Object)STATS);
        private static final Set<Component> BATCH_COMPONENTS = ImmutableSet.of((Object)DATA, (Object)PARTITION_INDEX, (Object)ROW_INDEX, (Object)COMPRESSION_INFO, (Object)FILTER, (Object)STATS, (Object[])new Component[0]);
        private static final Set<Component> ALL_COMPONENTS = ImmutableSet.of((Object)DATA, (Object)PARTITION_INDEX, (Object)ROW_INDEX, (Object)STATS, (Object)COMPRESSION_INFO, (Object)FILTER, (Object[])new Component[]{DIGEST, CRC, TOC});
        private static final Set<Component> GENERATED_ON_LOAD_COMPONENTS = ImmutableSet.of((Object)FILTER);

        public static class Types
        extends SSTableFormat.Components.Types {
            public static final Component.Type PARTITION_INDEX = Component.Type.createSingleton("PARTITION_INDEX", "Partitions.db", true, BtiFormat.class);
            public static final Component.Type ROW_INDEX = Component.Type.createSingleton("ROW_INDEX", "Rows.db", true, BtiFormat.class);
        }
    }
}

